/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.identity.api.constants.LoginStatus;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IAuLoginLogService;
import com.dtyunxi.yundt.cube.center.identity.dao.das.AuLoginLogDas;
import com.dtyunxi.yundt.cube.center.identity.dao.eo.AuLoginLogEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AuLoginLogServiceImpl
implements IAuLoginLogService {
    @Value(value="${token.validTime}")
    private String tokenValidTime;
    @Resource
    private AuLoginLogDas auLoginLogDas;

    @Override
    public void addLog(AuLoginLogEo auLoginLogEo) {
        this.auLoginLogDas.insert((BaseEo)auLoginLogEo);
    }

    @Override
    public PageInfo<AuLoginLogEo> queryUserLoginLogsByPage(AuLoginLogEo auLoginLogEo, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = this.auLoginLogDas.selectPage((BaseEo)auLoginLogEo);
        PageInfo userLoginLogEos = new PageInfo();
        CubeBeanUtils.copyProperties((Object)userLoginLogEos, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        return userLoginLogEos;
    }

    @Override
    public void saveLoginLog(UserLoginReqDto user, UserDto userDto, String token) {
        this.saveLoginLog(user, userDto, token, 1);
    }

    @Override
    public void saveLoginLog(UserLoginReqDto user, UserDto userDto, String token, Integer status) {
        if (LoginStatus.LOGIN_IN.equals(status)) {
            AuLoginLogEo auLoginLogEo = new AuLoginLogEo();
            auLoginLogEo.setAuthKey(token);
            auLoginLogEo.setApplicationId(userDto.getInstanceId());
            auLoginLogEo.setUserName(userDto.getUserName());
            auLoginLogEo.setUserId(userDto.getId());
            auLoginLogEo.setClientIp(user.getLoginIp());
            auLoginLogEo.setInstanceId(userDto.getInstanceId());
            auLoginLogEo.setTenantId(userDto.getTenantId());
            auLoginLogEo.setStatus(status);
            auLoginLogEo.setUserType(String.valueOf(userDto.getUserType()));
            auLoginLogEo.setDeviceId(user.getDeviceId());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long loginTimeStamp = System.currentTimeMillis();
            Date loginTime = new Date(loginTimeStamp);
            String loginTimeStr = simpleDateFormat.format(loginTime);
            auLoginLogEo.setLoginTime(loginTimeStr);
            long validTimeStamp = Long.parseLong(this.tokenValidTime);
            Date expectedLogoutTime = new Date(loginTimeStamp + validTimeStamp);
            String expectedLogoutTimeStr = simpleDateFormat.format(expectedLogoutTime);
            auLoginLogEo.setExpectedLogoutTime(expectedLogoutTimeStr);
            auLoginLogEo.setExtension(user.getExtension());
            auLoginLogEo.setExtension2(user.getExtension2());
            auLoginLogEo.setExtension3(user.getExtension3());
            auLoginLogEo.setExtension4(user.getExtension4());
            this.addLog(auLoginLogEo);
        } else {
            AuLoginLogEo auLoginLogEo = new AuLoginLogEo();
            auLoginLogEo.setAuthKey(token);
            auLoginLogEo = (AuLoginLogEo)this.auLoginLogDas.select((BaseEo)auLoginLogEo).get(0);
            auLoginLogEo.setStatus(LoginStatus.LOGIN_OUT);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long logoutTimeStamp = System.currentTimeMillis();
            Date logoutTime = new Date(logoutTimeStamp);
            String logoutTimeStr = simpleDateFormat.format(logoutTime);
            auLoginLogEo.setLogoutTime(logoutTimeStr);
            this.auLoginLogDas.updateSelective((BaseEo)auLoginLogEo);
        }
    }
}

