/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.constant.ThirdQueryType;
import com.dtyunxi.yundt.cube.center.user.api.dto.BindingsDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ThirdBindingQueryReq;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BindServiceImpl
implements IBindService {
    private static Logger logger = LoggerFactory.getLogger(BindServiceImpl.class);
    private int OPEND = 1;
    @Resource
    IUserApi iUserApi;
    @Resource
    private IUserQueryApi userQueryApi;

    @Override
    public UserDto bindThirdNo(Long instanceId, Long tenantId, Long userId, String openId, Integer thirdType) {
        return this.bindThirdNo(instanceId, tenantId, userId, openId, null, thirdType);
    }

    @Override
    public UserDto bindThirdNo(Long instanceId, Long tenantId, Long userId, String openId, Integer thirdType, String domain) {
        return this.bindThirdNo(instanceId, tenantId, userId, openId, null, thirdType, domain);
    }

    @Override
    public UserDto bindThirdNo(Long instanceId, Long tenantId, Long userId, String openId, String unionId, Integer thirdType) {
        return this.bindThirdNo(instanceId, tenantId, userId, openId, unionId, thirdType, this.OPEND);
    }

    @Override
    public UserDto bindThirdNo(Long instanceId, Long tenantId, Long userId, String openId, String unionId, Integer thirdType, String domain) {
        return this.bindThirdNo(instanceId, tenantId, userId, openId, unionId, thirdType, this.OPEND, domain);
    }

    @Override
    public UserDto bindThirdNo(Long instanceId, Long tenantId, Long userId, String openId, String unionId, Integer thirdType, Integer status) {
        return this.bindThirdNo(instanceId, tenantId, userId, openId, unionId, thirdType, status, null);
    }

    @Override
    public UserDto bindThirdNo(Long instanceId, Long tenantId, Long userId, String openId, String unionId, Integer thirdType, Integer status, String domain) {
        BindingsDto binding = new BindingsDto();
        binding.setInstanceId(instanceId);
        binding.setTenantId(tenantId);
        binding.setStatus(status);
        binding.setOpenId(openId);
        binding.setUnionId(unionId);
        binding.setThirdparyType(thirdType);
        binding.setUserDomain(domain);
        RestResponse restResponse = this.iUserApi.addBinding(userId, binding);
        if (restResponse.getResultCode().equals("0") && restResponse.getData() != null) {
            return this.queryThirdUser(openId, unionId, thirdType, instanceId, tenantId, domain);
        }
        IdentityExceptionCode.throwBizException((String)restResponse.getResultCode(), (String)restResponse.getResultMsg());
        UserDto userDto = this.queryThirdUser(openId, unionId, thirdType, instanceId, tenantId, domain);
        return userDto;
    }

    @Override
    public UserDto queryBindingUser(String openId, Integer thirdType, Long instanceId, Long tenantId) {
        try {
            String filter = String.format("{\"instanceId\":%d, \"tenantId\":%d}", instanceId, tenantId);
            RestResponse resUserDto = this.userQueryApi.queryBindingUserMultiInstanceTenant(openId, thirdType, filter);
            if (resUserDto.getResultCode().equals("0") && resUserDto.getData() != null) {
                return (UserDto)resUserDto.getData();
            }
            return null;
        }
        catch (BizException ex) {
            if (ex.getCode().equals(UserExceptionCode.USER_IDCHECK_FAIL.getCode())) {
                return null;
            }
            return null;
        }
    }

    @Override
    public UserDto queryThirdUser(String openId, String unionId, Integer thirdType, Long instanceId, Long tenantId) {
        return this.queryThirdUser(openId, unionId, thirdType, instanceId, tenantId, null);
    }

    @Override
    public UserDto queryThirdUser(String openId, String unionId, Integer thirdType, Long instanceId, Long tenantId, String domain) {
        ThirdBindingQueryReq queryReq = new ThirdBindingQueryReq().setOpenId(openId).setUnionId(unionId).setThirdType(thirdType.intValue()).setQueryType(ThirdQueryType.DEFAULT.getCode());
        queryReq.setTenantId(tenantId);
        queryReq.setInstanceId(instanceId);
        queryReq.setExtFields(null);
        queryReq.setDomain(domain);
        try {
            RestResponse resUserDto = this.userQueryApi.queryBindingUserByThirdId(JSON.toJSONString((Object)queryReq));
            if (resUserDto.getResultCode().equals("0") && resUserDto.getData() != null) {
                return (UserDto)resUserDto.getData();
            }
            return null;
        }
        catch (BizException ex) {
            if (ex.getCode().equals(UserExceptionCode.USER_IDCHECK_FAIL.getCode())) {
                return null;
            }
            return null;
        }
    }
}

