/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.DictionaryReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.DictionaryRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IDictionaryService;
import com.dtyunxi.yundt.cube.center.identity.dao.das.DictionaryDas;
import com.dtyunxi.yundt.cube.center.identity.dao.eo.DictionaryEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="dictionaryService")
public class DictionaryServiceImpl
implements IDictionaryService {
    @Resource
    private DictionaryDas dictionaryDas;

    @Override
    public void addDictionary(DictionaryReqDto dictionaryReqDto) {
        if (dictionaryReqDto == null) {
            return;
        }
        Assert.hasText((String)dictionaryReqDto.getDictKey(), (String)"\u5e38\u91cfkey\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dictionaryReqDto.getDictValue(), (String)"\u5e38\u91cfvalue\u4e0d\u80fd\u4e3a\u7a7a");
        DictionaryEo dictionaryEo = new DictionaryEo();
        DtoHelper.dto2Eo((BaseVo)dictionaryReqDto, (BaseEo)dictionaryEo);
        this.dictionaryDas.insert((BaseEo)dictionaryEo);
    }

    @Override
    public void modifyDictionary(Long id, DictionaryReqDto dictionaryReqDto) {
        DictionaryEo dictionaryEo = (DictionaryEo)this.dictionaryDas.selectByPrimaryKey(id);
        if (dictionaryEo == null) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.FAIL);
        }
        dictionaryEo = new DictionaryEo();
        DtoHelper.dto2Eo((BaseVo)dictionaryReqDto, (BaseEo)dictionaryEo);
        dictionaryEo.setId(id);
        this.dictionaryDas.updateSelective((BaseEo)dictionaryEo);
    }

    @Override
    public void removeDictionary(String keys, Long instanceId) {
        String[] key;
        if (StringUtils.isEmpty((CharSequence)keys)) {
            return;
        }
        if (instanceId == null) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.FAIL);
        }
        for (String k : key = keys.split(",")) {
            DictionaryEo dictionaryEo = new DictionaryEo();
            dictionaryEo.setDictKey(k);
            dictionaryEo.setInstanceId(instanceId);
            this.dictionaryDas.logicDelete((BaseEo)dictionaryEo);
        }
    }

    @Override
    public List<DictionaryRespDto> queryDictionaryByKey(String keys, String filter) {
        ArrayList<DictionaryRespDto> dictionaryRespDtoList = new ArrayList<DictionaryRespDto>();
        if (StringUtils.isEmpty((CharSequence)keys)) {
            return dictionaryRespDtoList;
        }
        Arrays.asList(keys.split(","));
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"key", (Object)StringUtils.join(sqlFilterList, (String)",")));
        DictionaryEo dictionaryEo = new DictionaryEo();
        dictionaryEo.setSqlFilters(sqlFilterList);
        DictionaryReqDto dictionaryReqDto = (DictionaryReqDto)JSON.parseObject((String)filter, DictionaryReqDto.class);
        dictionaryEo.setInstanceId(dictionaryReqDto.getInstanceId());
        dictionaryEo.setTenantId(dictionaryReqDto.getTenantId());
        List dictionaryEoList = this.dictionaryDas.select((BaseEo)dictionaryEo);
        DtoHelper.eoList2DtoList((Collection)dictionaryEoList, dictionaryRespDtoList, DictionaryRespDto.class);
        return dictionaryRespDtoList;
    }

    @Override
    public PageInfo<DictionaryRespDto> queryDictionaryByPage(String filter, Integer pageNum, Integer pageSize) {
        DictionaryReqDto dictionaryReqDto = (DictionaryReqDto)JSON.parseObject((String)filter, DictionaryReqDto.class);
        DictionaryEo dictionaryEo = new DictionaryEo();
        DtoHelper.dto2Eo((BaseVo)dictionaryReqDto, (BaseEo)dictionaryEo);
        PageInfo dictionaryEoPageInfo = this.dictionaryDas.selectPage((BaseEo)dictionaryEo, pageNum, pageSize);
        PageInfo dictionaryRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dictionaryRespDtoPageInfo, (Object)dictionaryEoPageInfo, (String[])new String[0]);
        ArrayList dictionaryRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)dictionaryEoPageInfo.getList(), dictionaryRespDtoList, DictionaryRespDto.class);
        dictionaryRespDtoPageInfo.setList(dictionaryRespDtoList);
        return dictionaryRespDtoPageInfo;
    }
}

