/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.utils.TokenUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.RegexUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.constants.LoginStatus;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.CheckTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.LoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.LoginSendMsgReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.RefreshTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.LoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.RefreshTokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.SsoAppInstanceRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.SsoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.api.vo.PwdMonitorStrategyVo;
import com.dtyunxi.yundt.cube.center.identity.biz.config.IdpUrlProperties;
import com.dtyunxi.yundt.cube.center.identity.biz.enums.IdentityEnum;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserLoginConfigService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.impl.AsyncLoginLog;
import com.dtyunxi.yundt.cube.center.identity.conf.ext.ILoginLogManageExt;
import com.dtyunxi.yundt.cube.center.identity.conf.ext.IPwdMonitorStrategyExt;
import com.dtyunxi.yundt.cube.center.identity.conf.param.AutoRedirectParam;
import com.dtyunxi.yundt.cube.center.identity.event.LoginEventDto;
import com.dtyunxi.yundt.cube.center.identity.event.LogoutEventDto;
import com.dtyunxi.yundt.cube.center.identity.mq.event.LoginEventPublisher;
import com.dtyunxi.yundt.cube.center.identity.mq.event.LogoutEventPublisher;
import com.dtyunxi.yundt.cube.center.identity.util.TokenBizUtil;
import com.dtyunxi.yundt.cube.center.user.api.constant.LoginNameType;
import com.dtyunxi.yundt.cube.center.user.api.constant.ValidTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.AccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.TenantDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserByLoginNameTypeQueryDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class TokenServiceImpl
implements ITokenService {
    private static Logger logger = LoggerFactory.getLogger(TokenServiceImpl.class);
    public static final PropertyFilter PASSWORD_FILTER = (object, name, value) -> !"password".equals(name);
    public static final String IDP_LOGIN_OUT_URL = "%s/oauth/logout?access_token=%s";
    @Value(value="${identity.loginLog:true}")
    private boolean loginLog;
    @Value(value="${yundt.cube.center.identity.setTokenUserNameSameWithDb:0}")
    private int setTokenUserNameSameWithDb;
    @Value(value="${yundt.cube.center.identity.shareTokenWithSameLoginSource:true}")
    private boolean shareTokenWithSameLoginSource;
    @Autowired
    AsyncLoginLog asyncLoginLog;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Resource
    private IApplicationQueryApi applicationQueryApi;
    @Resource
    private IVerifyCodeService verifyCodeService;
    @Resource
    private IUserLoginConfigService userLoginConfigService;
    @Autowired
    private ICacheService cacheService;
    @Resource
    LoginEventPublisher loginEventPublisher;
    @Resource
    LogoutEventPublisher logoutEventPublisher;
    @Resource
    private IUserService userService;
    @Autowired
    IdpUrlProperties idpUrlProperties;
    @CubeResource
    private AutoRedirectParam autoRedirectParam;
    @CubeResource
    private IPwdMonitorStrategyExt pwdMonitorStrategyExt;
    @CubeResource
    private ILoginLogManageExt loginLogManageExt;
    @Value(value="${token.validTime}")
    private String tokenValidTime;
    @Value(value="${token.secretKey}")
    private String tokenSecretKey;
    @Value(value="${code.error.validTime}")
    private Integer errorValidTime;
    @Value(value="${login.error.limit.count}")
    private Integer errorLimitCount;
    private static final String TOKEN_KEY_PREFIX = "token#";
    public static final String ERROR_COUNT_CACHE = "identity&login&error";
    private static final String TOKEN_LOGIN_SOURCE = "loginSource";
    public static final String DOMAIN = "domain";
    public static final String TOKEN_LABEL = "label";
    public static final String TOKEN_LABEL_A = "a";
    public static final String TOKEN_LABEL_B = "b";
    @Value(value="${token.refreshTime:1800}")
    private int tokenRefreshTime;

    private String getTokenKey(Map tokenMap) {
        String key = TOKEN_KEY_PREFIX + tokenMap.get("id");
        return key;
    }

    @Override
    public Map<String, Object> checkToken(String token) {
        return this.parseTokenByKeyAndTm(token);
    }

    private Map<String, Object> parseTokenByKeyAndTm(String token) {
        Map data;
        try {
            data = TokenUtil.parse((String)token, (String)this.tokenSecretKey);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790token\u51fa\u9519", (Throwable)e);
            throw new BizException(IdentityExceptionCode.TOKEN_CODE_NO_VALID.getCode(), IdentityExceptionCode.TOKEN_CODE_NO_VALID.getMsg());
        }
        String tokenKey = this.getFinalTokenKey(data);
        String cacheToken = (String)this.cacheService.getCache(tokenKey, String.class);
        if (!token.equals(cacheToken)) {
            throw new BizException(IdentityExceptionCode.TOKEN_CODE_NO_VALID.getCode(), IdentityExceptionCode.TOKEN_CODE_NO_VALID.getMsg());
        }
        return data;
    }

    @Override
    public Map<String, Object> checkToken(CheckTokenReqDto checkTokenReqDto) {
        String token = checkTokenReqDto.getToken();
        Map<String, Object> data = this.parseTokenByKeyAndTm(token);
        Long userTenantId = Long.parseLong(data.get("tenantId").toString());
        Long userInstanceId = Long.parseLong(data.get("instanceId").toString());
        TenantDto tenantDto = this.getTenantDto(checkTokenReqDto.getTenantId(), checkTokenReqDto.getInstanceId());
        if (tenantDto.getInstanceId().equals(userInstanceId)) {
            return data;
        }
        if (2 == tenantDto.getIsolation()) {
            IdentityExceptionCode.throwBizException((String)IdentityExceptionCode.USER_NO_EXIST.getCode(), (String)IdentityExceptionCode.USER_NO_EXIST.getMsg());
        } else {
            if (tenantDto.getId().equals(userTenantId)) {
                return data;
            }
            String[] trustDomains = TokenBizUtil.splitTrustDomain(tenantDto.getTrustDomain());
            if (null != trustDomains) {
                for (String trustDomain : trustDomains) {
                    if (!trustDomain.equals(userTenantId)) continue;
                    return data;
                }
            }
        }
        throw new BizException(IdentityExceptionCode.USER_NO_EXIST.getCode(), IdentityExceptionCode.USER_NO_EXIST.getMsg());
    }

    @Override
    public void deleteToken(String userId) {
        String key = TOKEN_KEY_PREFIX + userId;
        String token = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            this.cacheService.delCache(key);
            Map data = TokenUtil.parse((String)token, (String)this.tokenSecretKey);
            if (data.get(TOKEN_LOGIN_SOURCE) != null) {
                String loginSource = data.get(TOKEN_LOGIN_SOURCE).toString();
                String loginSourceKey = key + "-" + loginSource;
                this.cacheService.delCache(loginSourceKey);
            }
            this.saveLoginOutLog(userId, token);
        }
    }

    private void saveLoginOutLog(String userId, String token) {
        UserDto userDto = new UserDto();
        userDto.setId(Long.valueOf(userId));
        this.saveLoginLog(new UserLoginReqDto(), userDto, token, LoginStatus.LOGIN_OUT);
    }

    @Override
    public void deleteLoginToken(String userId, String loginSource) {
        String userIdKey = TOKEN_KEY_PREFIX + userId;
        String loginSourceKey = TOKEN_KEY_PREFIX + userId + "-" + loginSource;
        String token = (String)this.cacheService.getCache(userIdKey, String.class);
        this.cacheService.delCache(loginSourceKey);
        this.saveLoginOutLog(userId, token);
    }

    @Override
    public TokenRespDto createTokenByPhone(Integer loginType, UserDto userDto, Integer validTime) {
        UserLoginReqDto user = new UserLoginReqDto();
        user.setLoginType(loginType);
        user.setInstanceId(userDto.getInstanceId());
        user.setTenantId(userDto.getTenantId());
        user.setPhone(userDto.getPhone());
        user.setTokenValidTime(validTime);
        return this.createTokenRespDto(user, user.getPhone(), userDto, null);
    }

    @Override
    public TokenRespDto createSsoToken(UserLoginReqDto user) {
        String appKey = user.getAppKey();
        String appSign = user.getAppSign();
        String filter = "{\"tenantId\":" + user.getTenantId() + ",\"instanceId\":" + user.getInstanceId() + "}";
        RestResponse response = this.applicationQueryApi.queryByHostName(appKey, filter);
        AppInstanceDto instanceDto = (AppInstanceDto)response.getData();
        Assert.notNull((Object)instanceDto, (String)"\u5e94\u7528\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        String appSecret = instanceDto.getAppSecret();
        boolean isValid = TokenUtil.isValid((String)appSign, (String)appSecret);
        Assert.isTrue((boolean)isValid, (String)"APP \u7b7e\u540d\u4e0d\u5408\u6cd5");
        return this.createToken(user);
    }

    @Override
    public void deleteSsoToken(String appKey, String token) {
        Set appKeySet = (Set)this.cacheService.getCache(token, Set.class);
        if (appKeySet == null) {
            return;
        }
        if (appKeySet.isEmpty()) {
            this.cacheService.delCache(token);
        }
        appKeySet.remove(appKey);
        this.cacheService.setCache(token, (Object)appKeySet);
        try {
            Map data = TokenUtil.parse((String)token, (String)this.tokenSecretKey);
            Long userId = MapUtils.getLong((Map)data, (Object)"id");
            if (userId != null) {
                this.saveLoginOutLog(userId.toString(), token);
            }
        }
        catch (Exception e) {
            logger.info("token_code_no_valid,addLoginLog failed");
        }
    }

    private boolean needImageCode(Integer loginType) {
        return loginType.equals(IdentityEnum.LOGIN_USERNAME_PASSWORD_CODE.getCode());
    }

    private boolean needPhoneCode(Integer loginType) {
        return loginType.equals(IdentityEnum.LOGIN_PHOHE_CODE.getCode());
    }

    private boolean needSlideCode(Integer loginType) {
        return loginType.equals(IdentityEnum.LOGIN_USERNAME_PASSWORD_SLIDE_CODE.getCode());
    }

    private void checkImageCode(String uniqueId, String code) {
        boolean isValidCode;
        if (StringUtils.isEmpty((CharSequence)uniqueId) || StringUtils.isEmpty((CharSequence)code)) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.IMAGE_CODE_PARAM_ERROR);
        }
        if (!(isValidCode = this.verifyCodeService.checkImageCode(code, uniqueId))) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.IMAGE_CODE_NO_VALID);
        }
    }

    private void checkCode(String phone, String uniqueId, String code) {
        boolean isValidCode;
        if (StringUtils.isEmpty((CharSequence)uniqueId) || StringUtils.isEmpty((CharSequence)code)) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.PHONE_CODE_PARAM_ERROR);
        }
        if (!uniqueId.contains(phone)) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_CONFIRM_ERROR);
        }
        if (!(isValidCode = this.verifyCodeService.checkPhoneCode(code, uniqueId))) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_CONFIRM_ERROR);
        }
    }

    private void checkSlideCode(Integer slideX, String slideUniqueId) {
        boolean isValidCode;
        if (slideX == null) {
            IdentityExceptionCode.throwBizException((String)IdentityExceptionCode.EMPTY_PARAM_ERROR.getCode(), (String)(IdentityExceptionCode.EMPTY_PARAM_ERROR.getMsg() + "slideX \u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StringUtils.isEmpty((CharSequence)slideUniqueId)) {
            IdentityExceptionCode.throwBizException((String)IdentityExceptionCode.EMPTY_PARAM_ERROR.getCode(), (String)(IdentityExceptionCode.EMPTY_PARAM_ERROR.getMsg() + "slideUniqueId \u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (!(isValidCode = this.verifyCodeService.checkSlideCode(slideX, slideUniqueId, true))) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_CONFIRM_ERROR);
        }
    }

    @Override
    public TokenRespDto createToken(UserLoginReqDto userLoginReqDto) {
        PwdMonitorStrategyVo pwdMonitorStrategyVo;
        String loginStr = null;
        boolean isNeedPassword = this.isNeedValidPassWord(userLoginReqDto.getLoginType());
        HashMap<String, String> loginStrMap = new HashMap<String, String>();
        if (userLoginReqDto.getLoginType().equals(IdentityEnum.LOGIN_MULTIPLE_PASSWORD.getCode())) {
            loginStrMap.put("userName", userLoginReqDto.getUserName());
            loginStrMap.put("phone", userLoginReqDto.getPhone());
            loginStrMap.put("email", userLoginReqDto.getEmail());
        }
        if (!userLoginReqDto.getLoginType().equals(IdentityEnum.LOGIN_MULTIPLE_PASSWORD.getCode())) {
            loginStr = this.getLoginStr(userLoginReqDto);
            this.validParam(loginStr, userLoginReqDto);
        }
        TenantDto appTenantDto = this.getTenantDto(userLoginReqDto.getTenantId(), userLoginReqDto.getInstanceId());
        UserDto userDto = null;
        if (appTenantDto == null) {
            if (userLoginReqDto.getLoginType().equals(IdentityEnum.LOGIN_MULTIPLE_PASSWORD.getCode())) {
                if (null != loginStrMap.get("phone") && this.checkLoginStr((String)loginStrMap.get("phone")).getCode().equals(IdentityEnum.LOGIN_PHOHE_PASSWORD.getCode())) {
                    loginStr = (String)loginStrMap.get("phone");
                    userLoginReqDto.setLoginType(IdentityEnum.LOGIN_PHOHE_PASSWORD.getCode());
                    userDto = this.getUserDtoOldMultiple(userLoginReqDto, loginStr);
                }
                if (null == userDto && null != loginStrMap.get("userName")) {
                    loginStr = (String)loginStrMap.get("userName");
                    userLoginReqDto.setLoginType(IdentityEnum.LOGIN_USERNAME_PASSWORD.getCode());
                    userDto = this.getUserDtoOldMultiple(userLoginReqDto, loginStr);
                }
                if (null == userDto && null != loginStrMap.get("email") && this.checkLoginStr((String)loginStrMap.get("email")).getCode().equals(IdentityEnum.LOGIN_EMAIL_PASSWORD.getCode())) {
                    loginStr = (String)loginStrMap.get("email");
                    userLoginReqDto.setLoginType(IdentityEnum.LOGIN_EMAIL_PASSWORD.getCode());
                    userDto = this.getUserDtoOldMultiple(userLoginReqDto, loginStr);
                }
            } else {
                userDto = this.getUserDtoOld(userLoginReqDto, loginStr);
            }
            this.checkLoginAppLimit(userLoginReqDto, userDto);
        } else if (userLoginReqDto.getLoginType().equals(IdentityEnum.LOGIN_MULTIPLE_PASSWORD.getCode())) {
            if (null != loginStrMap.get("phone") && this.checkLoginStr((String)loginStrMap.get("phone")).getCode().equals(IdentityEnum.LOGIN_PHOHE_PASSWORD.getCode())) {
                loginStr = (String)loginStrMap.get("phone");
                userLoginReqDto.setLoginType(IdentityEnum.LOGIN_PHOHE_PASSWORD.getCode());
                userDto = this.getUserDtoMultiple(userLoginReqDto, loginStr, appTenantDto, isNeedPassword);
            }
            if (null == userDto && null != loginStrMap.get("userName")) {
                loginStr = (String)loginStrMap.get("userName");
                userLoginReqDto.setLoginType(IdentityEnum.LOGIN_USERNAME_PASSWORD.getCode());
                userDto = this.getUserDtoMultiple(userLoginReqDto, loginStr, appTenantDto, isNeedPassword);
            }
            if (null == userDto && null != loginStrMap.get("email") && this.checkLoginStr((String)loginStrMap.get("email")).getCode().equals(IdentityEnum.LOGIN_EMAIL_PASSWORD.getCode())) {
                loginStr = (String)loginStrMap.get("email");
                userLoginReqDto.setLoginType(IdentityEnum.LOGIN_EMAIL_PASSWORD.getCode());
                userDto = this.getUserDtoMultiple(userLoginReqDto, loginStr, appTenantDto, isNeedPassword);
            }
        } else {
            userDto = this.getUserDto(userLoginReqDto, loginStr, appTenantDto, isNeedPassword);
        }
        if (null == userDto) {
            throw new BizException(IdentityExceptionCode.USER_NO_EXIST.getCode(), IdentityExceptionCode.USER_NO_EXIST.getMsg() + "\u6216\u8be5\u7528\u6237\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        logger.info("Find user,userDto-info:id:" + userDto.getId() + "  TenantId:" + userDto.getTenantId() + "  InstanceId:" + userDto.getInstanceId() + " userName:" + userDto.getUserName());
        boolean isOpen = false;
        if (isNeedPassword && (pwdMonitorStrategyVo = this.pwdMonitorStrategyExt.execute(userDto)) != null) {
            isOpen = pwdMonitorStrategyVo.isOpen();
            if (!pwdMonitorStrategyVo.isResult()) {
                IdentityExceptionCode.throwBizException((String)IdentityExceptionCode.FAIL.getCode(), (String)IdentityExceptionCode.FAIL.getMsg());
            }
        }
        if (appTenantDto != null) {
            this.userService.handleValidResult(userDto.isValid(), userDto.getId(), isOpen, userDto.getIllegalReason());
        } else {
            IdentityExceptionCode.throwBizException((String)IdentityExceptionCode.TENANT_NOT_EXIST.getCode(), (String)IdentityExceptionCode.TENANT_NOT_EXIST.getMsg());
        }
        if (ValidTypeEnum.TEMP.getCode().equals(userDto.getValidType()) && userDto.getValidEndDate() != null && new Date().after(userDto.getValidEndDate())) {
            throw new BizException(IdentityExceptionCode.USER_ACCOUNT_OVERDUE.getCode(), IdentityExceptionCode.USER_ACCOUNT_OVERDUE.getMsg());
        }
        AppInstanceDto appInstanceDto = appTenantDto.getAppInstanceDto();
        LoginSendMsgReqDto loginSendMsgReqDto = new LoginSendMsgReqDto();
        if (null != appInstanceDto) {
            loginSendMsgReqDto.setTenantName(appTenantDto.getTenantName());
            loginSendMsgReqDto.setAppInstanceName(appInstanceDto.getAppName());
        }
        return this.createTokenRespDto(userLoginReqDto, loginStr, userDto, loginSendMsgReqDto);
    }

    private TenantDto getTenantDto(Long appTenantId, Long appInstanceId) {
        RestResponse appTenantRes;
        if (appTenantId == null) {
            logger.error("====================appInstanceId========================={}", (Object)appInstanceId);
            RestResponse appInsRes = this.applicationQueryApi.queryInsById(appInstanceId, "{}");
            if (!"0".equals(appInsRes.getResultCode()) || appInsRes.getData() == null) {
                IdentityExceptionCode.throwBizException((String)IdentityExceptionCode.APP_INSTANCE_NO_EXIST_BY_INSTANCE_ID.getCode(), (String)IdentityExceptionCode.APP_INSTANCE_NO_EXIST_BY_INSTANCE_ID.getMsg());
            }
        }
        if (!"0".equals((appTenantRes = this.userQueryApi.queryTenantByInstanceId(appInstanceId)).getResultCode()) || appTenantRes.getData() == null) {
            return null;
        }
        TenantDto tenantDto = (TenantDto)appTenantRes.getData();
        tenantDto.setInstanceId(appInstanceId);
        return tenantDto;
    }

    protected TokenRespDto createTokenRespDto(UserLoginReqDto user, String loginStr, UserDto userDto, LoginSendMsgReqDto loginSendMsgReqDto) {
        TokenRespDto resTokenDto = this.generateToken(user, loginStr, userDto);
        this.saveLoginLog(user, userDto, resTokenDto.getToken(), LoginStatus.LOGIN_IN);
        resTokenDto.setUserId(userDto.getId());
        return resTokenDto;
    }

    @Override
    public void saveLoginLog(UserLoginReqDto user, UserDto userDto, String token, Integer status) {
        if (!this.loginLog) {
            return;
        }
        if (LoginStatus.LOGIN_IN.equals(status)) {
            LoginEventDto loginEventDto = new LoginEventDto();
            loginEventDto.setUserId(userDto.getId());
            this.loginEventPublisher.send(loginEventDto);
        } else if (LoginStatus.LOGIN_OUT.equals(status)) {
            LogoutEventDto logoutEventDto = new LogoutEventDto();
            logoutEventDto.setUserId(userDto.getId());
            this.logoutEventPublisher.send(logoutEventDto);
        }
        Boolean result = this.loginLogManageExt.saveLoginLog(user, userDto, token, status);
        if (result == null) {
            this.asyncLoginLog.saveLoginLog(user, userDto, token, status);
        }
    }

    private UserDto getUserDtoOld(UserLoginReqDto user, String loginStr) {
        RestResponse resUserDto = IdentityEnum.LOGIN_PHOHE_PASSWORD.getCode().equals(user.getLoginType()) ? this.userQueryApi.queryByPhone(user.getPhone(), user.toQueryFilter()) : this.userQueryApi.queryByLoginStr(loginStr, user.getInstanceId(), user.toQueryFilter());
        if (!resUserDto.getResultCode().equals("0") || resUserDto.getData() == null) {
            throw new BizException(IdentityExceptionCode.USER_NO_EXIST.getCode(), IdentityExceptionCode.USER_NO_EXIST.getMsg());
        }
        if (!((UserDto)resUserDto.getData()).getStatus().equals(1)) {
            throw new BizException(IdentityExceptionCode.USER_DISABLE.getCode(), IdentityExceptionCode.USER_DISABLE.getMsg());
        }
        return (UserDto)resUserDto.getData();
    }

    private UserDto getUserDtoOldMultiple(UserLoginReqDto user, String loginStr) {
        RestResponse resUserDto = IdentityEnum.LOGIN_PHOHE_PASSWORD.getCode().equals(user.getLoginType()) ? this.userQueryApi.queryByPhone(user.getPhone(), user.toQueryFilter()) : this.userQueryApi.queryByLoginStr(loginStr, user.getInstanceId(), user.toQueryFilter());
        return (UserDto)resUserDto.getData();
    }

    private IdentityEnum checkLoginStr(String loginStr) {
        if (null != loginStr && RegexUtils.isMobile((String)loginStr)) {
            return IdentityEnum.LOGIN_PHOHE_PASSWORD;
        }
        if (null != loginStr && RegexUtils.isEmail((String)loginStr)) {
            return IdentityEnum.LOGIN_EMAIL_PASSWORD;
        }
        return IdentityEnum.LOGIN_MULTIPLE_PASSWORD;
    }

    private UserDto getUserDto(UserLoginReqDto userLoginReqDto, String loginStr, TenantDto appTenantDto, boolean isNeedPassword) {
        Long appTenantId = appTenantDto.getId();
        LoginNameType loginNameType = this.getLoginNameType(userLoginReqDto);
        Integer isolation = appTenantDto.getIsolation();
        if (isolation != null && isolation == 2) {
            RestResponse resUserDto = this.userQueryApi.queryByLoginNameAndType(this.toUserByLoginNameTypeQueryDto(userLoginReqDto, loginStr, loginNameType.getCode(), appTenantId, appTenantDto.getInstanceId(), isNeedPassword));
            if (resUserDto.getResultCode().equals("0") && resUserDto.getData() != null) {
                return (UserDto)resUserDto.getData();
            }
            if (!resUserDto.getResultCode().equals("0") || resUserDto.getData() == null) {
                throw new BizException(IdentityExceptionCode.USER_NO_EXIST.getCode(), IdentityExceptionCode.USER_NO_EXIST.getMsg());
            }
            throw new BizException(IdentityExceptionCode.USER_DISABLE.getCode(), IdentityExceptionCode.USER_DISABLE.getMsg());
        }
        UserDto userDto = this.getUserDtoByTenantId(userLoginReqDto, loginStr, loginNameType, appTenantId, isNeedPassword);
        if (null == userDto) {
            String[] trustDomains = TokenBizUtil.splitTrustDomain(appTenantDto.getTrustDomain());
            if (trustDomains == null || trustDomains.length == 0) {
                throw new BizException(IdentityExceptionCode.USER_NO_EXIST.getCode(), IdentityExceptionCode.USER_NO_EXIST.getMsg());
            }
            for (String tenantIdStr : trustDomains) {
                Long trustTenantId = Long.valueOf(tenantIdStr);
                userDto = this.getUserDtoByTenantId(userLoginReqDto, loginStr, loginNameType, trustTenantId, isNeedPassword);
                if (userDto == null) continue;
                return userDto;
            }
            throw new BizException(IdentityExceptionCode.USER_NO_EXIST.getCode(), IdentityExceptionCode.USER_NO_EXIST.getMsg());
        }
        return userDto;
    }

    private UserDto getUserDtoMultiple(UserLoginReqDto userLoginReqDto, String loginStr, TenantDto appTenantDto, boolean isNeedPassword) {
        String[] trustDomains;
        Long appTenantId = appTenantDto.getId();
        LoginNameType loginNameType = this.getLoginNameType(userLoginReqDto);
        Integer isolation = appTenantDto.getIsolation();
        if (isolation != null && isolation == 2) {
            RestResponse resUserDto = this.userQueryApi.queryByLoginNameAndType(this.toUserByLoginNameTypeQueryDto(userLoginReqDto, loginStr, loginNameType.getCode(), appTenantId, appTenantDto.getInstanceId(), isNeedPassword));
            if (resUserDto.getResultCode().equals("0") && resUserDto.getData() != null) {
                return (UserDto)resUserDto.getData();
            }
            if (!resUserDto.getResultCode().equals("0") || resUserDto.getData() == null) {
                throw new BizException(IdentityExceptionCode.USER_NO_EXIST.getCode(), IdentityExceptionCode.USER_NO_EXIST.getMsg());
            }
            throw new BizException(IdentityExceptionCode.USER_DISABLE.getCode(), IdentityExceptionCode.USER_DISABLE.getMsg());
        }
        UserDto userDto = this.getUserDtoByTenantId(userLoginReqDto, loginStr, loginNameType, appTenantId, isNeedPassword);
        if (null == userDto && (trustDomains = TokenBizUtil.splitTrustDomain(appTenantDto.getTrustDomain())) != null) {
            for (String tenantIdStr : trustDomains) {
                Long trustTenantId = Long.valueOf(tenantIdStr);
                userDto = this.getUserDtoByTenantId(userLoginReqDto, loginStr, loginNameType, trustTenantId, isNeedPassword);
                if (userDto == null) continue;
                return userDto;
            }
        }
        return userDto;
    }

    private UserByLoginNameTypeQueryDto toUserByLoginNameTypeQueryDto(UserLoginReqDto userLoginReqDto, String loginStr, Integer loginNameTypeCode, Long tenantId, Long instanceId, boolean isNeedPassword) {
        UserByLoginNameTypeQueryDto dto = new UserByLoginNameTypeQueryDto();
        dto.setLoginName(loginStr);
        dto.setLoginNameType(loginNameTypeCode);
        dto.setTenantId(tenantId);
        dto.setInstanceId(instanceId);
        if (null != userLoginReqDto.getExtFields() && null != userLoginReqDto.getExtFields().get(DOMAIN)) {
            dto.setDomain((String)userLoginReqDto.getExtFields().get(DOMAIN));
        }
        dto.setExtFields(null);
        if (isNeedPassword) {
            dto.setPassword(userLoginReqDto.getPassword());
        }
        return dto;
    }

    private LoginNameType getLoginNameType(UserLoginReqDto userLoginReqDto) {
        if (null != userLoginReqDto.getLoginType()) {
            Integer loginType = userLoginReqDto.getLoginType();
            if (loginType.intValue() == IdentityEnum.LOGIN_EMAIL_PASSWORD.getCode().intValue()) {
                return LoginNameType.EMAIL;
            }
            if (loginType.intValue() == IdentityEnum.LOGIN_PHOHE_PASSWORD.getCode().intValue() || loginType.intValue() == IdentityEnum.LOGIN_PHOHE_CODE.getCode().intValue()) {
                return LoginNameType.PHONE;
            }
            if (loginType.intValue() == IdentityEnum.LOGIN_USERNAME_PASSWORD.getCode().intValue() || loginType.intValue() == IdentityEnum.LOGIN_USERNAME_PASSWORD_CODE.getCode().intValue()) {
                return LoginNameType.USER_NAME;
            }
            if (loginType.intValue() == IdentityEnum.LOGIN_IDCARD_PASSWORD.getCode().intValue()) {
                return LoginNameType.USER_NAME;
            }
        }
        return LoginNameType.USER_NAME;
    }

    private UserDto getUserDtoByTenantId(UserLoginReqDto userLoginReqDto, String loginStr, LoginNameType loginNameType, Long tenantId, boolean isNeedPassword) {
        RestResponse resUser = this.userQueryApi.queryByLoginNameAndType(this.toUserByLoginNameTypeQueryDto(userLoginReqDto, loginStr, loginNameType.getCode(), tenantId, null, isNeedPassword));
        if (resUser.getResultCode().equals("0") && resUser.getData() != null) {
            return (UserDto)resUser.getData();
        }
        return null;
    }

    private void validParam(String loginStr, UserLoginReqDto user) {
        String expCode = IdentityExceptionCode.EMPTY_PARAM_ERROR.getCode();
        String expMessage = IdentityExceptionCode.EMPTY_PARAM_ERROR.getMsg();
        if (null == user.getInstanceId()) {
            IdentityExceptionCode.throwBizException((String)expCode, (String)(expMessage + "\u5e94\u7528\u5b9e\u4f8bId\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StringUtils.isEmpty((CharSequence)loginStr)) {
            if (user.getLoginType().equals(IdentityEnum.LOGIN_IDCARD_PASSWORD.getCode())) {
                IdentityExceptionCode.throwBizException((String)expCode, (String)(expMessage + " idCode \u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (user.getLoginType().equals(IdentityEnum.LOGIN_PHOHE_PASSWORD.getCode()) || user.getLoginType().equals(IdentityEnum.LOGIN_PHOHE_CODE.getCode())) {
                IdentityExceptionCode.throwBizException((String)expCode, (String)(expMessage + " phone \u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (user.getLoginType().equals(IdentityEnum.LOGIN_USERNAME_PASSWORD.getCode()) || user.getLoginType().equals(IdentityEnum.LOGIN_USERNAME_PASSWORD_SLIDE_CODE.getCode())) {
                IdentityExceptionCode.throwBizException((String)expCode, (String)(expMessage + " userName \u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (user.getLoginType().equals(IdentityEnum.LOGIN_EMAIL_PASSWORD.getCode())) {
                IdentityExceptionCode.throwBizException((String)expCode, (String)(expMessage + " email \u4e0d\u80fd\u4e3a\u7a7a"));
            }
        }
        if (this.isNeedValidPassWord(user.getLoginType()) && StringUtils.isEmpty((CharSequence)user.getPassword())) {
            IdentityExceptionCode.throwBizException((String)expCode, (String)(expMessage + " password \u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (this.isNeedValidCode(user.getLoginType()).booleanValue()) {
            this.checkValidCode(user.getLoginType(), user);
        }
    }

    @Override
    public Boolean isNeedValidCode(Integer loginType) {
        if (loginType.equals(IdentityEnum.LOGIN_USERNAME_PASSWORD_CODE.getCode()) || loginType.equals(IdentityEnum.LOGIN_PHOHE_CODE.getCode())) {
            return true;
        }
        return loginType.equals(IdentityEnum.LOGIN_USERNAME_PASSWORD_SLIDE_CODE.getCode());
    }

    private void checkValidCode(Integer loginType, UserLoginReqDto user) {
        if (loginType.equals(IdentityEnum.LOGIN_USERNAME_PASSWORD_CODE.getCode())) {
            this.checkImageCode(user.getUniqueId(), user.getCode());
        }
        if (loginType.equals(IdentityEnum.LOGIN_PHOHE_CODE.getCode())) {
            this.checkCode(user.getPhone(), user.getCheckCodeUniqueId(), user.getCheckCode());
        }
        if (loginType.equals(IdentityEnum.LOGIN_USERNAME_PASSWORD_SLIDE_CODE.getCode())) {
            this.checkSlideCode(user.getSlideX(), user.getSlideUniqueId());
        }
    }

    @Override
    public boolean isNeedValidPassWord(Integer loginType) {
        if (loginType.equals(IdentityEnum.LOGIN_EMAIL_PASSWORD.getCode())) {
            return true;
        }
        if (loginType.equals(IdentityEnum.LOGIN_PHOHE_PASSWORD.getCode())) {
            return true;
        }
        if (loginType.equals(IdentityEnum.LOGIN_USERNAME_PASSWORD.getCode())) {
            return true;
        }
        if (loginType.equals(IdentityEnum.LOGIN_IDCARD_PASSWORD.getCode())) {
            return true;
        }
        if (loginType.equals(IdentityEnum.LOGIN_USERNAME_PASSWORD_CODE.getCode())) {
            return true;
        }
        if (loginType.equals(IdentityEnum.LOGIN_MULTIPLE_PASSWORD.getCode())) {
            return true;
        }
        return loginType.equals(IdentityEnum.LOGIN_USERNAME_PASSWORD_SLIDE_CODE.getCode());
    }

    private String getLoginStr(UserLoginReqDto userDto) {
        Integer loginType = userDto.getLoginType();
        String loginStr = "";
        if (loginType.intValue() == IdentityEnum.LOGIN_EMAIL_PASSWORD.getCode().intValue()) {
            loginStr = userDto.getEmail();
        } else if (loginType.intValue() == IdentityEnum.LOGIN_PHOHE_PASSWORD.getCode().intValue() || loginType.intValue() == IdentityEnum.LOGIN_PHOHE_CODE.getCode().intValue()) {
            loginStr = userDto.getPhone();
        } else if (loginType.intValue() == IdentityEnum.LOGIN_USERNAME_PASSWORD.getCode().intValue() || loginType.intValue() == IdentityEnum.LOGIN_USERNAME_PASSWORD_CODE.getCode().intValue() || loginType.intValue() == IdentityEnum.LOGIN_USERNAME_PASSWORD_SLIDE_CODE.getCode().intValue()) {
            loginStr = userDto.getUserName();
        } else if (loginType.intValue() == IdentityEnum.LOGIN_IDCARD_PASSWORD.getCode().intValue()) {
            loginStr = userDto.getIdCode();
        }
        return loginStr;
    }

    private void addLoginErrorCount(String loginStr) {
        Integer count = (Integer)this.cacheService.getCache(ERROR_COUNT_CACHE + loginStr, Integer.class);
        if (count == null) {
            count = 1;
            this.cacheService.add(ERROR_COUNT_CACHE + loginStr, (Object)count, this.errorValidTime.intValue());
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            this.cacheService.setCache(ERROR_COUNT_CACHE + loginStr, (Object)count, this.errorValidTime.intValue());
        }
    }

    protected TokenRespDto generateToken(UserLoginReqDto userLoginReqDto, String loginStr, UserDto user) {
        long liveTime;
        String oldToken;
        TokenRespDto resTokenDto = new TokenRespDto();
        String loginSource = userLoginReqDto.getLoginSource();
        if (StringUtils.isNotBlank((CharSequence)loginSource)) {
            String loginSourceKey = TOKEN_KEY_PREFIX + user.getId() + "-" + loginSource;
            oldToken = (String)this.cacheService.getCache(loginSourceKey, String.class);
            liveTime = this.cacheService.getToLiveTime(loginSourceKey);
        } else {
            String userIdKey = TOKEN_KEY_PREFIX + user.getId();
            oldToken = (String)this.cacheService.getCache(userIdKey, String.class);
            liveTime = this.cacheService.getToLiveTime(userIdKey);
        }
        if (StringUtils.isNotBlank((CharSequence)oldToken) && this.shareTokenWithSameLoginSource) {
            resTokenDto.setToken(oldToken);
            resTokenDto.setTokenValidTime(Integer.valueOf(Long.valueOf(liveTime).intValue()));
            return resTokenDto;
        }
        HashMap<String, Object> userTokenMap = new HashMap<String, Object>();
        userTokenMap.put("id", user.getId());
        if (this.setTokenUserNameSameWithDb == 1) {
            userTokenMap.put("loginName", user.getUserName());
        } else {
            userTokenMap.put("loginName", loginStr);
        }
        userTokenMap.put("instanceId", user.getInstanceId());
        userTokenMap.put("tenantId", user.getTenantId());
        userTokenMap.put(TOKEN_LOGIN_SOURCE, userLoginReqDto.getLoginSource());
        if (StringUtils.isNotBlank((CharSequence)user.getDomain())) {
            userTokenMap.put(DOMAIN, user.getDomain());
        } else if (null != user.getExtFields() && StringUtils.isNotBlank((CharSequence)((String)user.getExtFields().get(DOMAIN)))) {
            userTokenMap.put(DOMAIN, user.getExtFields().get(DOMAIN));
        }
        int expirySeconds = Integer.parseInt(this.tokenValidTime);
        if (userLoginReqDto.getTokenValidTime() != null && userLoginReqDto.getTokenValidTime() > 0) {
            expirySeconds = userLoginReqDto.getTokenValidTime();
        }
        String token = TokenUtil.generate((String)this.tokenSecretKey, (int)expirySeconds, userTokenMap);
        this.cacheToken(userLoginReqDto, this.getTokenKey(userTokenMap), token, expirySeconds);
        resTokenDto.setToken(token);
        resTokenDto.setTokenValidTime(Integer.valueOf(expirySeconds));
        return resTokenDto;
    }

    protected void cacheToken(UserLoginReqDto userLoginReqDto, String tokenKey, String token, int expirySeconds) {
        if (StringUtils.isNotBlank((CharSequence)userLoginReqDto.getLoginSource())) {
            this.cacheService.setCache(tokenKey + "-" + userLoginReqDto.getLoginSource(), (Object)token, expirySeconds);
        } else {
            this.cacheService.setCache(tokenKey, (Object)token, expirySeconds);
        }
        if (StringUtils.isNotBlank((CharSequence)userLoginReqDto.getAppKey())) {
            this.cacheService.setCache(token, (Object)Sets.newHashSet((Object[])new String[]{userLoginReqDto.getAppKey()}), expirySeconds);
        }
    }

    private void checkLoginAppLimit(UserLoginReqDto user, UserDto userDto) {
        if (StringUtils.isBlank((CharSequence)user.getAppKey()) && StringUtils.isBlank((CharSequence)user.getAppSign())) {
            return;
        }
        Long instanceId = userDto.getInstanceId();
        String filter = "{\"tenantId\":" + userDto.getTenantId() + ",\"instanceId\":" + instanceId + "}";
        UserAccessVo userAccessVo = (UserAccessVo)this.accessQueryApi.queryUserAccess(userDto.getInstanceId(), userDto.getId(), filter).getData();
        Assert.notNull((Object)userAccessVo, (String)"\u7528\u6237\u6743\u9650\u672a\u5b9a\u4e49");
        boolean hLimit = false;
        Set accessDtoSet = userAccessVo.getAccessSet();
        for (AccessDto accessDto : accessDtoSet) {
            if (accessDto.getResourceType() != 3 || instanceId.compareTo(accessDto.getResourceId()) != 0 || accessDto.getPermissions() <= 0) continue;
            hLimit = true;
        }
        Assert.isTrue((boolean)hLimit, (String)"\u6ca1\u6709\u767b\u5f55\u6b64\u5b9e\u4f8b\u6743\u9650");
    }

    @Override
    public LoginRespDto login(LoginReqDto loginReqDto) {
        UserLoginReqDto userLoginReqDto = new UserLoginReqDto();
        CubeBeanUtils.copyProperties((Object)userLoginReqDto, (Object)loginReqDto, (String[])new String[0]);
        userLoginReqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        userLoginReqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        if (userLoginReqDto.getLoginType() == null) {
            userLoginReqDto.setLoginType(Integer.valueOf(0));
            userLoginReqDto.setPhone(loginReqDto.getUserName());
            userLoginReqDto.setEmail(loginReqDto.getUserName());
        }
        logger.info("tokenApi.createToken request param:{}", (Object)JSON.toJSONString((Object)userLoginReqDto, (SerializeFilter)PASSWORD_FILTER, (SerializerFeature[])new SerializerFeature[0]));
        TokenRespDto token = this.createToken(userLoginReqDto);
        LoginRespDto loginRespDto = new LoginRespDto();
        loginRespDto.setUserId(token.getUserId());
        loginRespDto.setToken(token.getToken());
        loginRespDto.setNeedModifyPassword(token.getNeedModifyPassword());
        loginRespDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        loginRespDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        loginRespDto.setTokenValidTime(token.getTokenValidTime());
        RestResponse restResponse = this.accessQueryApi.queryUserAccess(ServiceContext.getContext().getRequestInstanceId(), token.getUserId(), "{}");
        if (!"0".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        UserAccessVo userAccessVo = (UserAccessVo)restResponse.getData();
        Set roleDtoSet = userAccessVo.getRoleSet();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)roleDtoSet)) {
            for (RoleDto roleDto : roleDtoSet) {
                if ("BOCMANAGER".equalsIgnoreCase(roleDto.getCode())) {
                    loginRespDto.setRoleCode("BOCMANAGER");
                    break;
                }
                if ("APPMANAGER".equalsIgnoreCase(roleDto.getCode())) {
                    loginRespDto.setRoleCode("APPMANAGER");
                    break;
                }
                if ("SUPER_ADMIN".equalsIgnoreCase(roleDto.getCode())) {
                    loginRespDto.setRoleCode("SUPER_ADMIN");
                    loginRespDto.setTenantId(null);
                    break;
                }
                if (!"TENANT_ADMIN".equalsIgnoreCase(roleDto.getCode())) continue;
                loginRespDto.setRoleCode("TENANT_ADMIN");
                break;
            }
        }
        return loginRespDto;
    }

    @Override
    public SsoRespDto ssoLogin(UserLoginReqDto user) {
        Boolean autoRedirect;
        Integer checkAccess;
        Long tenantId = ServiceContext.getContext().getRequestTenantId() != null ? ServiceContext.getContext().getRequestTenantId() : user.getTenantId();
        Long instanceId = ServiceContext.getContext().getRequestInstanceId() != null ? ServiceContext.getContext().getRequestInstanceId() : user.getInstanceId();
        user.setInstanceId(instanceId);
        user.setTenantId(tenantId);
        TokenRespDto token = this.createToken(user);
        SsoRespDto ssoRespDto = new SsoRespDto();
        BeanUtils.copyProperties((Object)token, (Object)ssoRespDto);
        ssoRespDto.setTenantId(tenantId);
        ssoRespDto.setInstanceId(instanceId);
        ssoRespDto.setAutoRedirect(Boolean.valueOf(false));
        UserRoleReqDto userRoleReqDto = new UserRoleReqDto();
        userRoleReqDto.setUserId(token.getUserId());
        RestResponse restResponse = this.accessQueryApi.queryUserRole(userRoleReqDto);
        if (!"0".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        List userRoleRespDtoList = (List)restResponse.getData();
        logger.info("ssoLogin user role list: {}", (Object)JSON.toJSONString((Object)userRoleRespDtoList));
        boolean hasMoreRole = false;
        ArrayList appInstanceRespDtoList = Lists.newArrayList();
        List<Object> roleCodeList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)userRoleRespDtoList)) {
            Map<Long, List<UserRoleRespDto>> instanceRoleMap = userRoleRespDtoList.stream().collect(Collectors.groupingBy(BaseDto::getInstanceId));
            for (Map.Entry<Long, List<UserRoleRespDto>> entry : instanceRoleMap.entrySet()) {
                AppInstanceDto appInstanceDto = (AppInstanceDto)this.applicationQueryApi.queryInsById(entry.getKey(), null).getData();
                if (appInstanceDto == null || "MPC".equals(appInstanceDto.getCode())) continue;
                hasMoreRole = true;
                if ("BOC".equals(appInstanceDto.getCode())) {
                    List<UserRoleRespDto> roleList = entry.getValue();
                    roleCodeList = roleList.stream().map(UserRoleRespDto::getCode).collect(Collectors.toList());
                    if (roleCodeList.contains("BOCMANAGER")) {
                        ssoRespDto.setRoleCode("BOCMANAGER");
                        break;
                    }
                    if (!roleCodeList.contains("APPMANAGER")) continue;
                    ssoRespDto.setRoleCode("APPMANAGER");
                    continue;
                }
                SsoAppInstanceRespDto ssoAppInstanceRespDto = new SsoAppInstanceRespDto();
                BeanUtils.copyProperties((Object)appInstanceDto, (Object)ssoAppInstanceRespDto);
                appInstanceRespDtoList.add(ssoAppInstanceRespDto);
            }
        }
        if (!hasMoreRole && (checkAccess = Integer.valueOf(0)) != null && checkAccess == 1) {
            throw new BizException(IdentityExceptionCode.USER_NO_ROLE_ACCESS.getCode(), IdentityExceptionCode.USER_NO_ROLE_ACCESS.getMsg());
        }
        if (ssoRespDto.getRoleCode() == null && appInstanceRespDtoList.size() == 0 && roleCodeList.size() > 0) {
            roleCodeList.remove("BOCMANAGER");
            roleCodeList.remove("APPMANAGER");
            if (roleCodeList.size() > 0) {
                ssoRespDto.setRoleCode("BOCMANAGER");
            }
        }
        if (ssoRespDto.getRoleCode() == null && appInstanceRespDtoList.size() == 1 && (autoRedirect = (Boolean)this.autoRedirectParam.getValue()) != null && autoRedirect.booleanValue()) {
            ssoRespDto.setAutoRedirect(Boolean.valueOf(true));
            ssoRespDto.setAppInstanceRespDtoList((List)appInstanceRespDtoList);
            ssoRespDto.setRoleCode(null);
        }
        if (hasMoreRole && !ssoRespDto.getAutoRedirect().booleanValue() && !"BOCMANAGER".equals(ssoRespDto.getRoleCode())) {
            SsoAppInstanceRespDto bocInstance = new SsoAppInstanceRespDto();
            AppInstanceDto appInstanceDto = (AppInstanceDto)this.applicationQueryApi.queryInsById(instanceId, null).getData();
            BeanUtils.copyProperties((Object)appInstanceDto, (Object)bocInstance);
            appInstanceRespDtoList.add(bocInstance);
            ssoRespDto.setAppInstanceRespDtoList((List)appInstanceRespDtoList);
        }
        return ssoRespDto;
    }

    @Override
    public RefreshTokenRespDto refreshToken(RefreshTokenReqDto refreshTokenReqDto) {
        Map<String, Object> tokenData = this.parseTokenByKeyAndTm(refreshTokenReqDto.getToken());
        String tokenKey = this.getFinalTokenKey(tokenData);
        long liveTime = this.cacheService.getToLiveTime(tokenKey);
        if (liveTime > (long)this.tokenRefreshTime) {
            RefreshTokenRespDto refreshToken = new RefreshTokenRespDto();
            refreshToken.setToken(refreshTokenReqDto.getToken());
            refreshToken.setTokenValidTime(Integer.valueOf(Long.valueOf(liveTime).intValue()));
            return refreshToken;
        }
        if (!this.shareTokenWithSameLoginSource) {
            return this.getRefreshTokenRespDto(refreshTokenReqDto, tokenData, tokenKey);
        }
        String tokenLabel = "";
        if (tokenData.get(TOKEN_LABEL) != null) {
            tokenLabel = tokenData.get(TOKEN_LABEL).toString();
        }
        if (TOKEN_LABEL_A.equals(tokenLabel)) {
            return this.getRefreshTokenRespDtoByLabel(refreshTokenReqDto, tokenData, TOKEN_LABEL_B);
        }
        if (TOKEN_LABEL_B.equals(tokenLabel)) {
            return this.getRefreshTokenRespDtoByLabel(refreshTokenReqDto, tokenData, TOKEN_LABEL_A);
        }
        RefreshTokenRespDto refreshToken = new RefreshTokenRespDto();
        String tokenKeyA = this.getFinalTokenKeyByLabel(tokenData, TOKEN_LABEL_A);
        String tokenA = (String)this.cacheService.getCache(tokenKeyA, String.class);
        String tokenKeyB = this.getFinalTokenKeyByLabel(tokenData, TOKEN_LABEL_B);
        String tokenB = (String)this.cacheService.getCache(tokenKeyB, String.class);
        if (StringUtils.isNotBlank((CharSequence)tokenA) && StringUtils.isNotBlank((CharSequence)tokenB)) {
            long liveTimeB;
            long liveTimeA = this.cacheService.getToLiveTime(tokenKeyA);
            if (liveTimeA > (liveTimeB = this.cacheService.getToLiveTime(tokenKeyB))) {
                refreshToken.setToken(tokenA);
                refreshToken.setTokenValidTime(Integer.valueOf(Long.valueOf(liveTimeA).intValue()));
            } else {
                refreshToken.setToken(tokenB);
                refreshToken.setTokenValidTime(Integer.valueOf(Long.valueOf(liveTimeB).intValue()));
            }
            return refreshToken;
        }
        if (StringUtils.isNotBlank((CharSequence)tokenA)) {
            long liveTimeA = this.cacheService.getToLiveTime(tokenKeyA);
            refreshToken.setToken(tokenA);
            refreshToken.setTokenValidTime(Integer.valueOf(Long.valueOf(liveTimeA).intValue()));
            return refreshToken;
        }
        if (StringUtils.isNotBlank((CharSequence)tokenB)) {
            long liveTimeB = this.cacheService.getToLiveTime(tokenKeyB);
            refreshToken.setToken(tokenB);
            refreshToken.setTokenValidTime(Integer.valueOf(Long.valueOf(liveTimeB).intValue()));
            return refreshToken;
        }
        tokenData.put(TOKEN_LABEL, TOKEN_LABEL_A);
        return this.getRefreshTokenRespDto(refreshTokenReqDto, tokenData, tokenKeyA);
    }

    @Override
    public void exitLogin(String token, String userId, Long tenantId) {
        this.deleteToken(userId);
        String authorization = (String)this.cacheService.getCache("", token, String.class);
        String idpUrl = this.idpUrlProperties.getRedirectHost().get(tenantId);
        idpUrl = String.format(IDP_LOGIN_OUT_URL, idpUrl, authorization);
        ResponseEntity resEntity = null;
        try {
            resEntity = new RestTemplate().exchange(idpUrl, HttpMethod.GET, null, String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            logger.info("[ERROR]\u9000\u51faidp\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u6c42\u5934Authorization: [{}],url: [{}],\u9519\u8bef\u4fe1\u606f: [{}]", new Object[]{authorization, idpUrl, e.getMessage()});
        }
        String idpToken = (String)this.cacheService.getCache("", token, String.class);
        if (StringUtils.isNotEmpty((CharSequence)idpToken)) {
            this.cacheService.delCache("", token);
        }
    }

    private RefreshTokenRespDto getRefreshTokenRespDtoByLabel(RefreshTokenReqDto refreshTokenReqDto, Map<String, Object> tokenData, String tokenLabel) {
        String tokenKeyLabel = this.getFinalTokenKeyByLabel(tokenData, tokenLabel);
        String token = (String)this.cacheService.getCache(tokenKeyLabel, String.class);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            RefreshTokenRespDto refreshToken = new RefreshTokenRespDto();
            refreshToken.setToken(token);
            refreshToken.setTokenValidTime(Integer.valueOf(Long.valueOf(this.cacheService.getToLiveTime(tokenKeyLabel)).intValue()));
            return refreshToken;
        }
        tokenData.put(TOKEN_LABEL, tokenLabel);
        return this.getRefreshTokenRespDto(refreshTokenReqDto, tokenData, tokenKeyLabel);
    }

    private String getFinalTokenKey(Map<String, Object> tokenData) {
        String tokenKey = this.getTokenKey(tokenData);
        if (tokenData.get(TOKEN_LOGIN_SOURCE) != null) {
            String loginSource = tokenData.get(TOKEN_LOGIN_SOURCE).toString();
            tokenKey = tokenKey + "-" + loginSource;
        }
        if (tokenData.get(TOKEN_LABEL) != null) {
            String tokenLabel = tokenData.get(TOKEN_LABEL).toString();
            tokenKey = tokenKey + "-" + tokenLabel;
        }
        return tokenKey;
    }

    private String getFinalTokenKeyByLabel(Map<String, Object> tokenData, String tokenLabel) {
        String tokenKey = this.getTokenKey(tokenData);
        if (tokenData.get(TOKEN_LOGIN_SOURCE) != null) {
            String loginSource = tokenData.get(TOKEN_LOGIN_SOURCE).toString();
            tokenKey = tokenKey + "-" + loginSource;
        }
        return tokenKey + "-" + tokenLabel;
    }

    private RefreshTokenRespDto getRefreshTokenRespDto(RefreshTokenReqDto refreshTokenReqDto, Map<String, Object> tokenData, String tokenKey) {
        RefreshTokenRespDto refreshToken = new RefreshTokenRespDto();
        int expirySeconds = Integer.parseInt(this.tokenValidTime);
        if (refreshTokenReqDto.getTokenValidTime() != null && refreshTokenReqDto.getTokenValidTime() > 0) {
            expirySeconds = refreshTokenReqDto.getTokenValidTime();
        }
        String token = TokenUtil.generate((String)this.tokenSecretKey, (int)expirySeconds, tokenData);
        this.cacheService.setCache(tokenKey, (Object)token, expirySeconds);
        refreshToken.setToken(token);
        refreshToken.setTokenValidTime(Integer.valueOf(expirySeconds));
        return refreshToken;
    }
}

