/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.center.message.api.IMessageApi;
import com.dtyunxi.yundt.center.message.api.dto.request.MessageReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.CheckVerifyCodeAndModifyPasswordDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.SlideVerifyCodeRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.assemble.VerifyCodeConfig;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.util.SlideVerifyCodeUtil;
import com.dtyunxi.yundt.cube.center.identity.util.VerifyCodeUtil;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import sun.misc.BASE64Encoder;

@Service
public class VerifyCodeServiceImpl
implements IVerifyCodeService {
    private static Logger logger = LoggerFactory.getLogger(VerifyCodeServiceImpl.class);
    @Value(value="${yundt.cube.center.identity.removeCaptchaAfterCheck:true}")
    private boolean removeCache = true;
    @Resource
    private IMessageApi messageApi;
    @Autowired
    ICacheService cacheService;
    @Resource
    private VerifyCodeConfig verifyCodeConfig;
    @Resource
    private IUserService userService;

    private String getCodeTimeKey(String target) {
        String limitTimeKey = "codeLimitTime#" + target;
        return limitTimeKey;
    }

    private String getPhoneCodeKey(String key) {
        return "phone_code_unique_id#" + key;
    }

    private String getImageCodeKey(String key) {
        return "image_code_unique_id#" + key;
    }

    private String getEmailCodeKey(String key) {
        return "email_code_unique_id#" + key;
    }

    private String getSlideCodeKey(String key) {
        return "slide_code_unique_id#" + key;
    }

    @Override
    public String sendVerifyCode(Long tenantId, Long instanceId, Integer type, String target) {
        String uniqueId;
        String name;
        logger.info("----------------target{}\u53d1\u9001\u77ed\u4fe1-----------", (Object)target);
        if (type.equals(1)) {
            name = "\u624b\u673a[" + target + "]";
            uniqueId = "sms" + target + instanceId + System.currentTimeMillis();
        } else {
            name = "\u90ae\u7bb1[" + target + "]";
            uniqueId = "email" + target + instanceId + System.currentTimeMillis();
        }
        String code = (String)this.cacheService.getCache(this.getCodeTimeKey(target), String.class);
        if (!StringUtils.isEmpty((Object)code)) {
            throw new BizException(name + this.verifyCodeConfig.getSmsLimitTime() + "\u79d2\u5185\u4e0d\u80fd\u91cd\u53d1\u9a8c\u8bc1\u7801");
        }
        this.cacheService.setCache(this.getCodeTimeKey(target), (Object)uniqueId, this.verifyCodeConfig.getSmsLimitTime());
        String verifyCode = VerifyCodeUtil.generateTextCode(0, this.verifyCodeConfig.getVerifyCodeLength(), null);
        MessageReqDto messageReqDto = new MessageReqDto();
        messageReqDto.setMsgType(type);
        messageReqDto.setInstanceId(instanceId);
        messageReqDto.setTenantId(tenantId);
        messageReqDto.setTargets(target);
        messageReqDto.setTemplateParam((Map)Maps.newHashMap());
        if (type.equals(1)) {
            messageReqDto.setTemplateCode(this.verifyCodeConfig.getSmsTemplateCode());
            messageReqDto.getTemplateParam().put(this.verifyCodeConfig.getSmsTplParamCode(), verifyCode);
            messageReqDto.setContent("\u77ed\u4fe1\u9a8c\u8bc1\u7801" + verifyCode);
            try {
                this.messageApi.send(messageReqDto);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            logger.info("verifyCode:" + verifyCode + ";uniqueId:" + uniqueId + ",vaildTime:" + this.verifyCodeConfig.getCodeValidTime());
            this.cacheService.setCache(this.getPhoneCodeKey(uniqueId), (Object)verifyCode, this.verifyCodeConfig.getCodeValidTime());
        } else {
            messageReqDto.setContentType(Integer.valueOf(0));
            messageReqDto.setContent("");
            messageReqDto.setTitle(this.verifyCodeConfig.getEmailTitle());
            messageReqDto.setSender(this.verifyCodeConfig.getEmailSender());
            messageReqDto.setTemplateCode(this.verifyCodeConfig.getEmailTemplateCode());
            messageReqDto.getTemplateParam().put(this.verifyCodeConfig.getEmailTplParamCode(), verifyCode);
            try {
                this.messageApi.sendMail(messageReqDto);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.cacheService.setCache(this.getEmailCodeKey(uniqueId), (Object)verifyCode, this.verifyCodeConfig.getCodeValidTime());
        }
        return uniqueId;
    }

    @Override
    public Map<String, String> sendVerifyCodeByImg() {
        String verifyCode = VerifyCodeUtil.generateTextCode(1, 4, null).replaceAll("l", "L");
        String key = "image" + UUID.randomUUID().toString();
        this.cacheService.setCache(this.getImageCodeKey(key), (Object)verifyCode, 600);
        logger.info("\u9a8c\u8bc1\u7801\u83b7\u53d6,\u53d1\u9001\u7684\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a" + verifyCode);
        BufferedImage bufferedImage = VerifyCodeUtil.generateImageCode(verifyCode, 90, 30, 3, true, Color.WHITE, Color.BLACK, null);
        HashMap<String, String> result = new HashMap<String, String>(2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "JPEG", out);
        }
        catch (IOException e) {
            logger.info("", (Throwable)e);
            result.put("result", IdentityExceptionCode.VERIFYCODE_CREATE_ERROR.getMsg());
            return result;
        }
        byte[] data = out.toByteArray();
        BASE64Encoder encoder = new BASE64Encoder();
        String imgUrl = encoder.encode(data);
        result.put("image", imgUrl);
        result.put("uniqueId", key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SlideVerifyCodeRespDto sendSlideVerifyCode() {
        SlideVerifyCodeRespDto imageVerificationVo = null;
        File originImageFile = null;
        File templateImageFile = null;
        File borderImageFile = null;
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("static/targets/2.jpg");
            originImageFile = SlideVerifyCodeUtil.createFile(is, ".jpg");
            InputStream is2 = this.getClass().getClassLoader().getResourceAsStream("static/templates/template.png");
            templateImageFile = SlideVerifyCodeUtil.createFile(is2, ".png");
            InputStream is3 = this.getClass().getClassLoader().getResourceAsStream("static/templates/border.png");
            borderImageFile = SlideVerifyCodeUtil.createFile(is3, ".png");
            String borderImageFileType = borderImageFile.getName().substring(borderImageFile.getName().lastIndexOf(".") + 1);
            String originImageFileType = originImageFile.getName().substring(originImageFile.getName().lastIndexOf(".") + 1);
            String templateImageFileType = templateImageFile.getName().substring(templateImageFile.getName().lastIndexOf(".") + 1);
            BufferedImage verificationImage = ImageIO.read(originImageFile);
            BufferedImage readTemplateImage = ImageIO.read(templateImageFile);
            BufferedImage borderImage = ImageIO.read(borderImageFile);
            imageVerificationVo = SlideVerifyCodeUtil.generateCutoutCoordinates(verificationImage, readTemplateImage);
            int Y = imageVerificationVo.getY();
            int X = imageVerificationVo.getX();
            imageVerificationVo = SlideVerifyCodeUtil.pictureTemplateCutout(originImageFile, originImageFileType, templateImageFile, templateImageFileType, imageVerificationVo.getX(), imageVerificationVo.getY());
            imageVerificationVo = SlideVerifyCodeUtil.cutoutImageEdge(imageVerificationVo, borderImage, borderImageFileType);
            imageVerificationVo.setY(Y);
            String key = UUID.randomUUID().toString();
            this.cacheService.setCache(this.getSlideCodeKey(key), (Object)X, this.verifyCodeConfig.getCodeValidTime());
            imageVerificationVo.setSlideUniqueId(key);
        }
        catch (IOException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.IO_EXCEPTON);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(originImageFile);
                FileUtils.deleteQuietly(templateImageFile);
                FileUtils.deleteQuietly(borderImageFile);
                throw throwable;
            }
            FileUtils.deleteQuietly((File)originImageFile);
            FileUtils.deleteQuietly(templateImageFile);
            FileUtils.deleteQuietly(borderImageFile);
        }
        FileUtils.deleteQuietly((File)originImageFile);
        FileUtils.deleteQuietly((File)templateImageFile);
        FileUtils.deleteQuietly((File)borderImageFile);
        return imageVerificationVo;
    }

    @Override
    public boolean checkSlideCode(Integer slideX, String slideUniqueId, boolean clearCache) {
        boolean flag = false;
        if (slideX != null && !StringUtils.isEmpty((Object)slideUniqueId)) {
            Integer slideXCache = (Integer)this.cacheService.getCache(this.getSlideCodeKey(slideUniqueId), Integer.class);
            boolean bl = flag = slideXCache != null && Math.abs(slideXCache - slideX) <= this.verifyCodeConfig.getThresholdValue();
            if (clearCache) {
                this.cacheService.expire(this.getSlideCodeKey(slideUniqueId), 0);
            }
        }
        return flag;
    }

    @Override
    public boolean checkImageCode(String verifycode, String uniqueId) {
        boolean flag = false;
        if (!StringUtils.isEmpty((Object)verifycode) && !StringUtils.isEmpty((Object)uniqueId)) {
            String verifyCodeCache = "";
            if (!StringUtils.isEmpty((Object)uniqueId) && !StringUtils.isEmpty((Object)(verifyCodeCache = (String)this.cacheService.getCache(this.getImageCodeKey(uniqueId), String.class))) && this.removeCache) {
                this.cacheService.delCache(this.getImageCodeKey(uniqueId));
            }
            flag = verifyCodeCache != null && verifyCodeCache.equalsIgnoreCase(verifycode);
        }
        return flag;
    }

    @Override
    public boolean checkVerifyCode(String verifycode, String uniqueId, Integer type) {
        if (type.equals(1)) {
            return this.checkImageCode(verifycode, uniqueId);
        }
        if (type.equals(2)) {
            return this.checkPhoneCode(verifycode, uniqueId);
        }
        if (type.equals(3)) {
            return this.checkEmailCode(verifycode, uniqueId);
        }
        return false;
    }

    @Override
    public boolean checkPhoneCode(String verifycode, String uniqueId) {
        logger.info("------------verifycode:" + verifycode + ",uniqueId:" + uniqueId);
        boolean flag = false;
        if (!StringUtils.isEmpty((Object)verifycode) && !StringUtils.isEmpty((Object)uniqueId)) {
            String verifyCodeCache = "";
            if (!StringUtils.isEmpty((Object)uniqueId)) {
                verifyCodeCache = (String)this.cacheService.getCache(this.getPhoneCodeKey(uniqueId), String.class);
            }
            flag = verifyCodeCache != null && verifyCodeCache.equalsIgnoreCase(verifycode);
            logger.info("----------------verifyCodeCache:" + verifyCodeCache);
        }
        return flag;
    }

    @Override
    public boolean checkEmailCode(String verifycode, String uniqueId) {
        boolean flag = false;
        if (!StringUtils.isEmpty((Object)verifycode) && !StringUtils.isEmpty((Object)uniqueId)) {
            String verifyCodeCache = "";
            if (!StringUtils.isEmpty((Object)uniqueId)) {
                verifyCodeCache = (String)this.cacheService.getCache(this.getEmailCodeKey(uniqueId), String.class);
            }
            flag = verifyCodeCache != null && verifyCodeCache.equalsIgnoreCase(verifycode);
        }
        return flag;
    }

    @Override
    public void checkVerifyCodeAndModifyPassword(CheckVerifyCodeAndModifyPasswordDto reqDto) {
        boolean checkResult = false;
        if (reqDto.getType().equals(2)) {
            checkResult = this.checkPhoneCode(reqDto.getVerifyCode(), reqDto.getUniqueId());
        } else if (reqDto.getType().equals(3)) {
            checkResult = this.checkEmailCode(reqDto.getVerifyCode(), reqDto.getUniqueId());
        }
        if (!checkResult) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_CONFIRM_ERROR);
        }
        Long instanceId = reqDto.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : reqDto.getInstanceId();
        Long userId = this.userService.checkAccount(reqDto.getTarget(), reqDto.getDomain(), instanceId);
        this.userService.modifyPassword(userId, reqDto.getNewPassword());
    }
}

