/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.LoginSendMsgReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoginMsgProducer {
    private static final Logger logger = LoggerFactory.getLogger(LoginMsgProducer.class);
    @Resource
    private ICommonsMqService commonsMqService;

    public void sendLoginMqMsg(LoginSendMsgReqDto loginSendMsgReqDto) {
        loginSendMsgReqDto.setEventCode("login_event_msg_sending");
        HashMap tplValueMap = Maps.newHashMap();
        tplValueMap.put("userName", loginSendMsgReqDto.getUserName());
        loginSendMsgReqDto.setTplValueMap((Map)tplValueMap);
        try {
            logger.info("LoginMsgProducer.loginSendMsgReqDto:{}", (Object)JSON.toJSONString((Object)loginSendMsgReqDto));
            String loginSendMsgReqDtoJson = JSON.toJSONString((Object)loginSendMsgReqDto);
            this.commonsMqService.sendSingleMessage("login_event_msg_sending", (Object)loginSendMsgReqDtoJson);
        }
        catch (Exception e) {
            logger.error("LoginMsgProducer.loginSendMsgReqDto error..." + e.getMessage());
            throw new BizException(IdentityExceptionCode.Login_SEND_MESSAGE_ERROR.getCode(), IdentityExceptionCode.Login_SEND_MESSAGE_ERROR.getMsg());
        }
    }
}

