/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.strategy.impl;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IAppSecretService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.dao.eo.AppSecretEo;
import com.dtyunxi.yundt.cube.center.identity.strategy.impl.WeChatHandlerImpl;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.WeiXinUtil;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.annotation.Resource;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="wechatMiniProgramHandler")
public class WechatMiniProgramHandler
extends WeChatHandlerImpl {
    private static final Logger logger = LoggerFactory.getLogger(WechatMiniProgramHandler.class);
    private static final ObjectMapper om = new ObjectMapper();
    @Resource
    private IAppSecretService appSecretService;
    @Resource
    private IBindService bindService;
    @Resource
    private ITokenService tokenService;
    @Resource
    private IVerifyCodeService verifyCodeService;
    @Resource
    private IUserService userService;
    @Resource
    private IUserApi userApi;
    @Resource
    private ICacheService cacheService;
    private static final String LOGIN_URL = "https://api.weixin.qq.com/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code";
    private static final String SESSION_KEY = "sessionKey";
    private static final String UNION_ID = "unionId";

    @Override
    public ThirdUserInfoRespDto thirdAuth(AuthLoginReqDto authLoginReqDto) {
        return null;
    }

    @Override
    public ThirdLoginRespDto tokenAuth(AuthLoginTokenReqDto authLoginTokenReqDto) {
        AppSecretEo appSecretEo = this.createAppSecreteEo(authLoginTokenReqDto);
        Authorization mpAuthorization = WeiXinUtil.getMPAuthorization(String.format(LOGIN_URL, appSecretEo.getKeyAppId(), appSecretEo.getKeyAppSecret(), authLoginTokenReqDto.getCode()));
        this.cacheService.setCache(mpAuthorization.getOpenid() + UNION_ID, (Object)mpAuthorization.getUnionid(), 3600);
        this.cacheService.setCache(mpAuthorization.getOpenid() + SESSION_KEY, (Object)mpAuthorization.getSessionKey());
        UserInfo userInfo = new UserInfo();
        userInfo.setOpenid(mpAuthorization.getOpenid());
        userInfo.setUnionid(mpAuthorization.getUnionid());
        return this.tokenAuthProcess(authLoginTokenReqDto, mpAuthorization, userInfo);
    }

    @Override
    public TokenRespDto bindLogin(UserBindLoginThirdDto userBindLoginThirdDto) {
        UserInfo userInfo = new UserInfo();
        userInfo.setOpenid(userBindLoginThirdDto.getOpenId());
        String unionId = (String)this.cacheService.getCache(userBindLoginThirdDto.getOpenId() + UNION_ID, String.class);
        String sessionKey = (String)this.cacheService.getCache(userBindLoginThirdDto.getOpenId() + SESSION_KEY, String.class);
        if (StringUtils.isEmpty((Object)sessionKey)) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.OPEN_ID_ERROR);
        }
        try {
            String phone = this.getPhone(sessionKey, userBindLoginThirdDto.getIv(), userBindLoginThirdDto.getPhone());
            userBindLoginThirdDto.setPhone(phone);
        }
        catch (Exception e) {
            logger.error("\u89e3\u5bc6\u5c0f\u7a0b\u5e8f\u8fd4\u56de\u7684\u624b\u673a\u53f7\u52a0\u5bc6\u6570\u636e\u51fa\u9519:{}", (Object)e.getMessage());
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.FAIL);
        }
        userInfo.setUnionid(unionId);
        userInfo.setNickname(userBindLoginThirdDto.getNickName());
        userInfo.setHeadimgurl(userBindLoginThirdDto.getAvatar());
        return this.bindLoginProcess(userBindLoginThirdDto, userInfo);
    }

    @Override
    protected int getBindingLoginType(String type) {
        return 6;
    }

    public String getPhone(String sessionKey, String iv, String encrypted) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, JsonProcessingException {
        byte[] encrypted64 = Base64.decodeBase64((String)encrypted);
        byte[] key64 = Base64.decodeBase64((String)sessionKey);
        byte[] iv64 = Base64.decodeBase64((String)iv);
        IvParameterSpec ivSpec = new IvParameterSpec(iv64);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(key64, "AES");
        cipher.init(2, (Key)keySpec, ivSpec);
        String result = new String(cipher.doFinal(encrypted64), StandardCharsets.UTF_8);
        Map map = (Map)om.readValue(result, Map.class);
        return (String)map.get("purePhoneNumber");
    }

    @Override
    protected int getThirdType() {
        return 6;
    }
}

