/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.constants.LoginSource;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.util.HttpClientUtil;
import com.dtyunxi.yundt.cube.center.identity.util.JsonUtil;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DingtalkOauthUtil {
    private static Logger logger = LoggerFactory.getLogger(DingtalkOauthUtil.class);
    private static final String GET_DING_TOKEN_URL = "https://oapi.dingtalk.com/sns/gettoken";
    private static final String GET_DING_PERSISTENT_CODE_URL = "https://oapi.dingtalk.com/sns/get_persistent_code";
    private static final String GET_DING_SNS_TOKEN_URL = "https://oapi.dingtalk.com/sns/get_sns_token";
    private static final String GET_DING_USER_INFO_URL = "https://oapi.dingtalk.com/sns/getuserinfo";
    private static final String GET_SCAN_AUTH_CODE_URL = "https://oapi.dingtalk.com/connect/oauth2/sns_authorize?appid=%s&response_type=code&scope=snsapi_login&state=STATE&redirect_uri=%s";
    private static final String GET_AUTH_CODE_URL = "https://oapi.dingtalk.com/connect/qrconnect?appid=%s&response_type=code&scope=snsapi_login&redirect_uri=%s";

    public static String getAccessToken(String appId, String appSecret) {
        String accessToken = null;
        if (appId != null && appSecret != null) {
            StringBuilder reqUrl = new StringBuilder(GET_DING_TOKEN_URL);
            reqUrl.append("?").append("appid=").append(appId).append("&").append("appsecret=").append(appSecret);
            String resultJson = HttpClientUtil.sendGet(reqUrl.toString(), null);
            JSONObject jsonObject = JSON.parseObject((String)resultJson);
            Integer errCode = jsonObject.getInteger("errcode");
            String errmsg = jsonObject.getString("errmsg");
            if (errCode == 0 && "ok".equals(errmsg)) {
                accessToken = jsonObject.getString("access_token");
            } else {
                IdentityExceptionCode.throwBizException((String)String.valueOf(errCode), (String)errmsg);
                logger.error("\u83b7\u53d6\u9489\u9489accessToken\u5931\u8d25\uff1a{}", (Object)resultJson);
            }
        }
        return accessToken;
    }

    public static Map<String, String> getPersistentCode(String accessToken, String tmpAuthCode) {
        Map<String, String> dingtalkDto = null;
        if (StringUtils.isNotEmpty((CharSequence)accessToken) && StringUtils.isNotEmpty((CharSequence)tmpAuthCode)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tmp_auth_code", tmpAuthCode);
            String resultJson = HttpClientUtil.sendPostWithJson("https://oapi.dingtalk.com/sns/get_persistent_code?access_token=" + accessToken, JsonUtil.toJson(map));
            dingtalkDto = JsonUtil.toObject(resultJson, new TypeReference<Map<String, String>>(){});
            if (Integer.parseInt(dingtalkDto.get("errcode")) != 0) {
                logger.error("\u83b7\u53d6\u9489\u9489\u7528\u6237\u6388\u6743\u7684\u6301\u4e45\u6388\u6743\u7801\u5931\u8d25\uff1a{}", (Object)resultJson);
                IdentityExceptionCode.throwBizException((String)dingtalkDto.get("errcode"), (String)dingtalkDto.get("errmsg"));
                dingtalkDto = null;
            }
        }
        return dingtalkDto;
    }

    public static Authorization getSnsToken(String accessToken, String openid, String persistentCode) {
        Authorization authorization = new Authorization();
        Map<String, String> dingtalkDto = null;
        if (openid != null && persistentCode != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("openid", openid);
            map.put("persistent_code", persistentCode);
            String resultJson = HttpClientUtil.sendPostWithJson("https://oapi.dingtalk.com/sns/get_sns_token?access_token=" + accessToken, JsonUtil.toJson(map));
            if (resultJson != null) {
                dingtalkDto = JsonUtil.toObject(resultJson, new TypeReference<Map<String, String>>(){});
            }
            if (dingtalkDto == null || dingtalkDto != null && Integer.valueOf(dingtalkDto.get("errcode")) != 0) {
                logger.error("\u83b7\u53d6\u9489\u9489\u7528\u6237Sns\u6388\u6743\u7801\u5931\u8d25\uff1a{}", (Object)resultJson);
                dingtalkDto = null;
                IdentityExceptionCode.throwBizException((String)dingtalkDto.get("errcode"), (String)dingtalkDto.get("errmsg"));
            }
        }
        authorization.setAccessToken((String)dingtalkDto.get("sns_token"));
        authorization.setOpenid(openid);
        return authorization;
    }

    public static UserInfo getUserInfo(String sns_token) {
        String resultJson = HttpClientUtil.sendGet("https://oapi.dingtalk.com/sns/getuserinfo?sns_token=" + sns_token, null);
        JSONObject jsonObject = JSON.parseObject((String)resultJson);
        Integer errCode = jsonObject.getInteger("errcode");
        UserInfo userInfo = new UserInfo();
        if (errCode == 0) {
            JSONObject userInfoString = jsonObject.getJSONObject("user_info");
            String openid = userInfoString.getString("openid");
            String unionid = userInfoString.getString("unionid");
            userInfo.setOpenid(openid);
            userInfo.setUnionid(unionid);
        } else {
            logger.error("\u83b7\u53d6\u9489\u9489\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)resultJson);
            IdentityExceptionCode.throwBizException((String)String.valueOf(jsonObject.getInteger("errcode")), (String)jsonObject.getString("errmsg"));
            userInfo = null;
        }
        return userInfo;
    }

    public static String urlEnodeUTF8(String str) {
        String result = str;
        try {
            result = URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception arg2) {
            arg2.printStackTrace();
        }
        return result;
    }

    public static String getTemplateCode(String APPID, AuthLoginReqDto authLoginReqDto) {
        Integer loginSource = authLoginReqDto.getLoginSource();
        String getAuthCodeUrl = LoginSource.EMBEDDED_SCAN.equals(loginSource) ? GET_SCAN_AUTH_CODE_URL : GET_AUTH_CODE_URL;
        String redirectUrl = authLoginReqDto.getRedirectUri();
        Map map = authLoginReqDto.getExtFields();
        String url = String.format(getAuthCodeUrl, APPID, DingtalkOauthUtil.urlEnodeUTF8(redirectUrl));
        StringBuilder sb = new StringBuilder(url);
        if (map != null && map.get("state") != null) {
            sb.append("&state=");
            sb.append(map.get("state"));
        }
        return sb.toString();
    }
}

