/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IAppConfigService;
import com.dtyunxi.yundt.cube.center.identity.dao.das.AppConfigDas;
import com.dtyunxi.yundt.cube.center.identity.dao.eo.AppConfigEo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppConfigServiceImpl
implements IAppConfigService {
    @Autowired
    private AppConfigDas appConfigDas;
    @Autowired
    private ICacheService cacheService;

    @Override
    public Long insert(AppConfigEo applyConfig) {
        AppConfigEo eo = new AppConfigEo();
        CubeBeanUtils.copyProperties((Object)eo, (Object)applyConfig, (String[])new String[0]);
        this.appConfigDas.insert((BaseEo)eo);
        return applyConfig.getId();
    }

    @Override
    public AppConfigEo findByAppId(String appId) {
        String cacheKey = "AppId_" + appId;
        AppConfigEo appConfigEo = (AppConfigEo)this.cacheService.getCache(cacheKey, AppConfigEo.class);
        if (appConfigEo == null) {
            AppConfigEo appConfig = this.appConfigDas.findByAppId(appId);
            if (appConfig != null) {
                this.cacheService.setCache(cacheKey, (Object)appConfig, 36000);
            }
            appConfigEo = appConfig;
        }
        return appConfigEo;
    }

    @Override
    public boolean checkAppId(String appId) {
        AppConfigEo appConfigEo = this.findByAppId(appId);
        return appConfigEo != null;
    }
}

