/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AddressReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.BindLoginWithoutAccessTokenDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.MemberRegisterReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IMemberService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.api.ISecurityApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserInfoApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.TenantDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserValidDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserServiceImpl
implements IUserService {
    private Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IUserApi userApi;
    @Resource
    private IUserInfoApi userInfoApi;
    @Resource
    private ISecurityApi securityApi;
    @Resource
    private IMemberService memberService;
    @Autowired
    ICacheService cacheService;

    @Override
    public UserDto queryByLoginStr(String loginStr, Long instanceId) {
        block3: {
            try {
                RestResponse resUserDto = this.userQueryApi.queryByLoginStr(loginStr, instanceId, "{}");
                if (resUserDto.getResultCode().equals("0") && resUserDto.getData() != null) {
                    UserDto userDto = (UserDto)resUserDto.getData();
                    return userDto;
                }
            }
            catch (BizException ex) {
                if (!ex.getCode().equals(UserExceptionCode.USER_IDCHECK_FAIL.getCode())) break block3;
                return null;
            }
        }
        return null;
    }

    @Override
    public UserDto queryByLoginStr(String loginStr, UserDto userDto) {
        block3: {
            try {
                RestResponse resUserDto = this.userQueryApi.queryByLoginStr(loginStr, userDto.getInstanceId(), JSON.toJSONString((Object)userDto.getExtFields()));
                if (resUserDto.getResultCode().equals("0") && resUserDto.getData() != null) {
                    return (UserDto)resUserDto.getData();
                }
            }
            catch (BizException ex) {
                if (!ex.getCode().equals(UserExceptionCode.USER_IDCHECK_FAIL.getCode())) break block3;
                return null;
            }
        }
        return null;
    }

    @Override
    public UserDto addUserByPhone(Long instanceId, Long tenantId, String phone, String password, Integer userType, Map<String, Object> extFields) {
        UserDto userDto = new UserDto();
        userDto.setInstanceId(instanceId);
        userDto.setTenantId(tenantId);
        userDto.setPhone(phone);
        userDto.setPassword(password);
        userDto.setUserType(userType);
        userDto.setStatus(Integer.valueOf(1));
        userDto.setActiveState(Integer.valueOf(1));
        userDto.setExtFields(extFields);
        this.userApi.addUser(instanceId, userDto).getData();
        UserDto user = this.queryByLoginStr(phone, userDto);
        this.activateMember(user);
        return user;
    }

    @Override
    public UserDto addUserByPhone(UserDto userDto, UserInfo userInfo) {
        userDto.setStatus(Integer.valueOf(1));
        userDto.setActiveState(Integer.valueOf(1));
        userDto.setNickName(userInfo.getNickname());
        userDto.setAvatar(userInfo.getHeadimgurl());
        this.userApi.addUser(userDto.getInstanceId(), userDto).getData();
        UserDto user = this.queryByLoginStr(userDto.getPhone(), userDto);
        this.activateMember(user);
        return user;
    }

    @Override
    public UserDto addUserByPhone(BindLoginWithoutAccessTokenDto dto, String password, Integer userType) {
        UserDto userDto = new UserDto();
        userDto.setInstanceId(dto.getInstanceId());
        userDto.setTenantId(dto.getTenantId());
        userDto.setPhone(dto.getPhone());
        userDto.setPassword(password);
        userDto.setUserType(userType);
        userDto.setStatus(Integer.valueOf(1));
        userDto.setActiveState(Integer.valueOf(1));
        userDto.setExtFields(dto.getExtFields());
        userDto.setAvatar(dto.getAvatar());
        userDto.setNickName(dto.getNickName());
        this.userApi.addUser(dto.getInstanceId(), userDto).getData();
        UserDto user = this.queryByLoginStr(dto.getPhone(), userDto);
        this.activateMember(user);
        return user;
    }

    @Override
    public UserDto addDefaultUser(Long instanceId, Long tenantId, Integer userType, Map<String, Object> extFields, String password) {
        UserDto userDto = new UserDto();
        userDto.setInstanceId(instanceId);
        userDto.setTenantId(tenantId);
        userDto.setUserType(userType);
        userDto.setStatus(Integer.valueOf(1));
        userDto.setActiveState(Integer.valueOf(1));
        if (password == null) {
            userDto.setPassword(this.generatePassword());
        } else {
            userDto.setPassword(password);
        }
        userDto.setExtFields(extFields);
        Long id = (Long)this.userApi.addUser(instanceId, userDto).getData();
        UserDto user = (UserDto)this.userQueryApi.queryById(id, "{}").getData();
        this.activateMember(user);
        return user;
    }

    @Override
    public UserDto addDefaultUser(Long instanceId, Long tenantId, Integer userType, Map<String, Object> extFields, String password, UserInfo userInfo) {
        UserReqDto userDetailInfo = new UserReqDto();
        userDetailInfo.setInstanceId(instanceId);
        userDetailInfo.setTenantId(tenantId);
        userDetailInfo.setUserType(userType);
        userDetailInfo.setExtFields(extFields);
        userDetailInfo.setPassword(password);
        return this.addDefaultUser(userDetailInfo, userInfo);
    }

    @Override
    public UserDto addDefaultUser(UserReqDto userDetailInfo, UserInfo userInfo) {
        Long userId = (Long)this.userApi.addUser(userDetailInfo.getInstanceId(), this.assembleUser(userDetailInfo, userInfo)).getData();
        this.addUserAddress(userDetailInfo, userId);
        UserDto user = (UserDto)this.userQueryApi.queryById(userId, "{}").getData();
        this.activateMember(user, userDetailInfo.getAddressList());
        return user;
    }

    private void addUserAddress(UserReqDto userDetailInfo, Long userId) {
        List addressReqDtoList = userDetailInfo.getAddressList();
        if (!CollectionUtils.isEmpty((Collection)addressReqDtoList)) {
            for (AddressReqDto addressReqDto : addressReqDtoList) {
                AddressDto addressDto = new AddressDto();
                CubeBeanUtils.copyProperties((Object)addressDto, (Object)addressReqDto, (String[])new String[0]);
                this.userInfoApi.addAddress(userId, addressDto);
            }
        }
    }

    private UserDto assembleUser(UserReqDto userDetailInfo, UserInfo userInfo) {
        UserDto userDto = new UserDto();
        CubeBeanUtils.copyProperties((Object)userDto, (Object)userDetailInfo, (String[])new String[0]);
        if (userDto.getPassword() == null) {
            userDto.setPassword(this.generatePassword());
        }
        userDto.setNickName(userInfo.getNickname());
        userDto.setAvatar(userInfo.getHeadimgurl());
        userDto.setStatus(Integer.valueOf(1));
        userDto.setActiveState(Integer.valueOf(1));
        return userDto;
    }

    @Override
    public UserDto addDefaultUserWithoutAccessToken(Long instanceId, Long tenantId, Map<String, Object> extFields) {
        UserDto userDto = new UserDto();
        userDto.setInstanceId(instanceId);
        userDto.setTenantId(tenantId);
        userDto.setUserType(Integer.valueOf(1));
        userDto.setStatus(Integer.valueOf(1));
        userDto.setActiveState(Integer.valueOf(1));
        userDto.setPassword(this.generatePassword());
        userDto.setExtFields(extFields);
        Long id = (Long)this.userApi.addUser(instanceId, userDto).getData();
        UserDto user = (UserDto)this.userQueryApi.queryById(id, "{}").getData();
        this.activateMember(user);
        return user;
    }

    @Override
    public UserDto addDefaultUserWithoutAccessToken(BindLoginWithoutAccessTokenDto dto) {
        UserDto userDto = new UserDto();
        userDto.setInstanceId(dto.getInstanceId());
        userDto.setTenantId(dto.getTenantId());
        userDto.setUserType(Integer.valueOf(1));
        userDto.setStatus(Integer.valueOf(1));
        userDto.setActiveState(Integer.valueOf(1));
        userDto.setPassword(this.generatePassword());
        userDto.setExtFields(dto.getExtFields());
        userDto.setAvatar(dto.getAvatar());
        userDto.setNickName(dto.getNickName());
        Long id = (Long)this.userApi.addUser(dto.getInstanceId(), userDto).getData();
        UserDto user = (UserDto)this.userQueryApi.queryById(id, "{}").getData();
        this.activateMember(user);
        return user;
    }

    private String getSex(String wxSex) {
        if (wxSex == null) {
            return null;
        }
        String sex = null;
        if (wxSex.equals("1")) {
            sex = "2";
        } else if (wxSex.equals("2")) {
            sex = "1";
        } else if (wxSex.equals("0")) {
            sex = "0";
        }
        if (sex == null) {
            return wxSex;
        }
        return "_" + sex;
    }

    private void activateMember(UserDto userDto) {
        this.memberService.activateMember(this.getMemberRegisterReqDto(userDto));
    }

    private MemberRegisterReqDto getMemberRegisterReqDto(UserDto userDto) {
        MemberRegisterReqDto memberRegisterReqDto = new MemberRegisterReqDto();
        CubeBeanUtils.copyProperties((Object)memberRegisterReqDto, (Object)userDto, (String[])new String[0]);
        memberRegisterReqDto.setUserId(userDto.getId());
        if (StringUtils.isNotEmpty((CharSequence)userDto.getPhone())) {
            memberRegisterReqDto.setRegisterType(Integer.valueOf(2));
        } else if (StringUtils.isNotEmpty((CharSequence)userDto.getEmail())) {
            memberRegisterReqDto.setRegisterType(Integer.valueOf(3));
        } else {
            memberRegisterReqDto.setRegisterType(Integer.valueOf(4));
        }
        if (null != userDto.getSex()) {
            memberRegisterReqDto.setSex(this.getSex(userDto.getSex()));
        }
        return memberRegisterReqDto;
    }

    private void activateMember(UserDto userDto, List<AddressReqDto> addressList) {
        MemberRegisterReqDto memberRegisterReqDto = this.getMemberRegisterReqDto(userDto);
        memberRegisterReqDto.setAddressList(addressList);
        this.memberService.activateMember(memberRegisterReqDto);
    }

    @Override
    public void updateUserPhone(Long userId, String phone, Long instanceId, Long tenantId) {
        this.updateUserPhone(userId, phone, instanceId, tenantId, null);
    }

    @Override
    public void updateUserPhone(Long userId, String phone, Long instanceId, Long tenantId, String domain) {
        UserDto userDto = new UserDto();
        userDto.setPhone(phone);
        userDto.setInstanceId(instanceId);
        userDto.setTenantId(tenantId);
        userDto.setDomain(domain);
        this.userApi.update(userId, userDto);
    }

    @Override
    public Boolean isValidUser(TenantDto appTenantDto, String loginStr, Boolean isNeedPassword, UserLoginReqDto user, Long userId, boolean isOpen) {
        boolean isValid = true;
        if (isNeedPassword.booleanValue()) {
            UserValidDto userValidDto = new UserValidDto();
            userValidDto.setTenantId(appTenantDto.getId());
            userValidDto.setInstanceId(appTenantDto.getInstanceId());
            userValidDto.setLoginStr(loginStr);
            userValidDto.setPassword(user.getPassword());
            userValidDto.setExtFields(user.getExtFields());
            RestResponse resValid = null;
            try {
                resValid = this.userApi.isValid(userValidDto);
            }
            catch (Exception e) {
                isValid = false;
                this.logger.error("", (Throwable)e);
            }
            if (resValid != null) {
                if (resValid.getResultCode().equals("0")) {
                    isValid = (Boolean)resValid.getData();
                    if (isOpen) {
                        this.afterValidPwdHandler(userId, isValid);
                    }
                    if (!isValid) {
                        IdentityExceptionCode.throwBizException((String)IdentityExceptionCode.PASSWORD_NO_VALID.getCode(), (String)IdentityExceptionCode.PASSWORD_NO_VALID.getMsg());
                    }
                } else {
                    IdentityExceptionCode.throwBizException((String)resValid.getResultCode(), (String)resValid.getResultMsg());
                }
            }
        }
        return isValid;
    }

    @Override
    public void handleValidResult(boolean isValid, Long userId, boolean isOpen, String illegalReason) {
        if (isOpen) {
            this.afterValidPwdHandler(userId, isValid);
        }
        if (!isValid) {
            throw new BizException(IdentityExceptionCode.USER_ILLEGAL.getCode(), IdentityExceptionCode.USER_ILLEGAL.getMsg() + "\uff0c" + illegalReason);
        }
    }

    protected void afterValidPwdHandler(Long userId, boolean isValid) {
    }

    private String generatePassword() {
        int A = 65;
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        char N = (char)(A + hour);
        String dateFormat = DateUtil.getDateFormat((Date)calendar.getTime(), (String)"yyMMdd-mm");
        String key = N + dateFormat;
        Long i = this.cacheService.incr(key);
        return key + i;
    }

    @Override
    public Long checkAccount(String loginStr, String domain, Long instanceId) {
        UserDto userDto;
        UserDto queryUserDto = new UserDto();
        queryUserDto.setInstanceId(instanceId);
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            HashMap<String, String> queryExtFields = new HashMap<String, String>();
            queryExtFields.put("domain", domain);
            queryUserDto.setExtFields(queryExtFields);
        }
        if ((userDto = this.queryByLoginStr(loginStr, queryUserDto)) == null) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.USER_ACCOUNT_NO_EXIST);
        }
        return userDto.getId();
    }

    @Override
    public void modifyPassword(Long userId, String newPassword) {
        this.securityApi.resetPasswordByAdmin(userId, newPassword);
    }
}

