/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.strategy;

import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.enums.ThirdLoginTypeMappingEnums;
import com.dtyunxi.yundt.cube.center.identity.strategy.AbstractThirdLoginHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ThirdLoginContext
implements CommandLineRunner {
    private Logger logger = LoggerFactory.getLogger(ThirdLoginContext.class);
    @Resource
    private List<AbstractThirdLoginHandler> thirdLoginHandlers;
    private Map<Integer, AbstractThirdLoginHandler> thirdLoginHandlerMap;

    public void run(String ... args) throws Exception {
        this.thirdLoginHandlerMap = new HashMap<Integer, AbstractThirdLoginHandler>();
        for (AbstractThirdLoginHandler handler : this.thirdLoginHandlers) {
            this.thirdLoginHandlerMap.put(handler.getThirdType(), handler);
        }
    }

    public AbstractThirdLoginHandler getThirdLoginType(Integer loginType) {
        Assert.notNull((Object)loginType, (String)"\u7b2c\u4e09\u65b9\u767b\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3anull");
        AbstractThirdLoginHandler thirdLoginHandler = this.thirdLoginHandlerMap.get(loginType);
        if (thirdLoginHandler == null) {
            this.logger.error("\u6839\u636eLoginType\u83b7\u53d6\u7b2c\u4e09\u65b9\u767b\u5f55BeanName\u5931\u8d25,LoginType:{}", (Object)loginType);
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.UNSUPPORT_THIRD_TYPE);
        }
        return thirdLoginHandler;
    }

    @Deprecated
    public AbstractThirdLoginHandler getThirdLoginInstance(Integer loginType) {
        String beanName;
        AbstractThirdLoginHandler thirdLoginHandler;
        if (loginType == null) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.UNSUPPORT_THIRD_TYPE);
        }
        if ((thirdLoginHandler = this.thirdLoginHandlerMap.get(beanName = ThirdLoginTypeMappingEnums.getBeanNameByLoginType(loginType))) == null) {
            this.logger.error("\u6839\u636eLoginType\u83b7\u53d6\u7b2c\u4e09\u65b9\u767b\u5f55BeanName\u5931\u8d25,LoginType:{},BeanName{}", (Object)loginType, (Object)beanName);
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.UNSUPPORT_THIRD_TYPE);
        }
        return thirdLoginHandler;
    }
}

