/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.strategy.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.constants.LoginSource;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IAppSecretService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.dao.eo.AppSecretEo;
import com.dtyunxi.yundt.cube.center.identity.strategy.AbstractThirdLoginHandler;
import com.dtyunxi.yundt.cube.center.identity.util.AlipayOauthUtil;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service(value="alipayHandler")
public class AlipayHandlerImpl
extends AbstractThirdLoginHandler {
    public static final String ALIPAY_PUBLIC_KEY = "publicKey";
    @Resource
    private IAppSecretService appSecretService;
    @Resource
    private IBindService bindService;
    @Resource
    private ITokenService tokenService;
    @Resource
    private IVerifyCodeService verifyCodeService;
    @Resource
    private IUserService userService;
    @Resource
    private IUserApi userApi;

    @Override
    protected int getThirdType() {
        return 9;
    }

    @Override
    public ThirdUserInfoRespDto thirdAuth(AuthLoginReqDto authLoginReqDto) {
        AppSecretEo appSecretEo = this.createAppSecreteEo(authLoginReqDto);
        ThirdUserInfoRespDto thirdUserInfoRespDto = new ThirdUserInfoRespDto();
        thirdUserInfoRespDto.setResultUrl(AlipayOauthUtil.getOAuthCodeUrl(appSecretEo.getKeyAppId(), authLoginReqDto.getRedirectUri()));
        return thirdUserInfoRespDto;
    }

    @Override
    public ThirdLoginRespDto tokenAuth(AuthLoginTokenReqDto authLoginTokenReqDto) {
        AppSecretEo appSecretEo = this.createAppSecreteEo(authLoginTokenReqDto);
        String publicKey = this.getPublicKey(appSecretEo);
        Authorization authorization = AlipayOauthUtil.getAuthorization(appSecretEo.getKeyAppId(), appSecretEo.getKeyAppSecret(), publicKey, authLoginTokenReqDto.getCode());
        Assert.hasText((String)authorization.getAccessToken(), (String)"\u672a\u83b7\u53d6\u5230accessToken\uff01");
        UserInfo userInfo = new UserInfo();
        if (LoginSource.APP.equals(authLoginTokenReqDto.getLoginSource())) {
            userInfo = AlipayOauthUtil.getUserInfo(appSecretEo.getKeyAppId(), appSecretEo.getKeyAppSecret(), publicKey, authorization.getAccessToken());
        } else if (LoginSource.MINI_PROGRAM.equals(authLoginTokenReqDto.getLoginSource())) {
            userInfo.setOpenid(authorization.getOpenid());
        }
        Assert.hasText((String)userInfo.getOpenid(), (String)"\u672a\u83b7\u53d6\u5230userId\uff01");
        ThirdLoginRespDto thirdLoginRespDto = this.tokenAuthProcess(authLoginTokenReqDto, authorization, userInfo);
        if (LoginSource.MINI_PROGRAM.equals(authLoginTokenReqDto.getLoginSource())) {
            return thirdLoginRespDto;
        }
        if (StringUtils.isEmpty((Object)thirdLoginRespDto.getToken())) {
            UserBindLoginThirdDto userBindLoginThirdDto = new UserBindLoginThirdDto();
            CubeBeanUtils.copyProperties((Object)userBindLoginThirdDto, (Object)authLoginTokenReqDto, (String[])new String[0]);
            userBindLoginThirdDto.setThirdToken(authorization.getAccessToken());
            userBindLoginThirdDto.setOpenId(authorization.getOpenid());
            TokenRespDto tokenRespDto = this.bindLogin(userBindLoginThirdDto);
            thirdLoginRespDto.setUserId(tokenRespDto.getUserId());
            thirdLoginRespDto.setToken(tokenRespDto.getToken());
        }
        return thirdLoginRespDto;
    }

    private String getPublicKey(AppSecretEo appSecretEo) {
        String keyAppConfig = appSecretEo.getKeyAppConfig();
        Assert.hasText((String)keyAppConfig, (String)"\u652f\u4ed8\u5b9d\u516c\u94a5\u672a\u914d\u7f6e\uff0c\u914d\u7f6e\u65b9\u5f0f");
        Map map = (Map)JSONObject.parseObject((String)keyAppConfig, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String publicKey = (String)map.get(ALIPAY_PUBLIC_KEY);
        Assert.hasText((String)keyAppConfig, (String)"\u652f\u4ed8\u5b9d\u516c\u94a5\u672a\u914d\u7f6e\uff0c\u914d\u7f6e\u65b9\u5f0f");
        return publicKey;
    }

    @Override
    public TokenRespDto bindLogin(UserBindLoginThirdDto userBindLoginThirdDto) {
        AppSecretEo appSecretEo = this.createAppSecreteEo(userBindLoginThirdDto);
        String publicKey = this.getPublicKey(appSecretEo);
        UserInfo userInfo = AlipayOauthUtil.getUserInfo(appSecretEo.getKeyAppId(), appSecretEo.getKeyAppSecret(), publicKey, userBindLoginThirdDto.getThirdToken());
        return this.bindLoginProcess(userBindLoginThirdDto, userInfo);
    }

    @Override
    protected IAppSecretService getAppSecretService() {
        return this.appSecretService;
    }

    @Override
    protected IBindService getBindService() {
        return this.bindService;
    }

    @Override
    protected ITokenService getTokenService() {
        return this.tokenService;
    }

    @Override
    protected IVerifyCodeService getVerifyCodeService() {
        return this.verifyCodeService;
    }

    @Override
    protected IUserService getUserService() {
        return this.userService;
    }

    @Override
    protected IUserApi getUserApi() {
        return this.userApi;
    }

    @Override
    protected int getBindingLoginType(String type) {
        return 9;
    }
}

