/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.strategy.impl;

import cn.hutool.core.lang.Assert;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IAppSecretService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.dao.eo.AppSecretEo;
import com.dtyunxi.yundt.cube.center.identity.strategy.AbstractThirdLoginHandler;
import com.dtyunxi.yundt.cube.center.identity.util.DingtalkOauthUtil;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="dingTalkHandler")
public class DingTalkHandlerImpl
extends AbstractThirdLoginHandler {
    @Resource
    private IAppSecretService appSecretService;
    @Resource
    private IBindService bindService;
    @Resource
    private ITokenService tokenService;
    @Resource
    private IVerifyCodeService verifyCodeService;
    @Resource
    private IUserService userService;
    @Resource
    private IUserApi userApi;

    @Override
    public ThirdUserInfoRespDto thirdAuth(AuthLoginReqDto authLoginReqDto) {
        AppSecretEo appSecretEo = this.createAppSecreteEo(authLoginReqDto);
        ThirdUserInfoRespDto thirdUserInfoRespDto = new ThirdUserInfoRespDto();
        thirdUserInfoRespDto.setResultUrl(DingtalkOauthUtil.getTemplateCode(appSecretEo.getKeyAppId(), authLoginReqDto));
        return thirdUserInfoRespDto;
    }

    @Override
    public ThirdLoginRespDto tokenAuth(AuthLoginTokenReqDto authLoginTokenReqDto) {
        AppSecretEo appSecretEo = this.createAppSecreteEo(authLoginTokenReqDto);
        String accessToken = DingtalkOauthUtil.getAccessToken(appSecretEo.getKeyAppId(), appSecretEo.getKeyAppSecret());
        Assert.notNull((Object)accessToken, (String)IdentityExceptionCode.GET_ACCESS_TOKEN_ERROR.getMsg(), (Object[])new Object[0]);
        Map<String, String> map = DingtalkOauthUtil.getPersistentCode(accessToken, authLoginTokenReqDto.getCode());
        Assert.notEmpty(map, (String)IdentityExceptionCode.GET_PERSISTENCE_CODE_ERROR.getMsg(), (Object[])new Object[0]);
        Authorization authorization = DingtalkOauthUtil.getSnsToken(accessToken, map.get("openid"), map.get("persistent_code"));
        Assert.notNull((Object)authorization, (String)IdentityExceptionCode.GET_SNS_TOKEN_ERROR.getMsg(), (Object[])new Object[0]);
        UserInfo userInfo = DingtalkOauthUtil.getUserInfo(authorization.getAccessToken());
        return this.tokenAuthProcess(authLoginTokenReqDto, authorization, userInfo);
    }

    @Override
    public TokenRespDto bindLogin(UserBindLoginThirdDto userBindLoginThirdDto) {
        UserInfo userInfo = DingtalkOauthUtil.getUserInfo(userBindLoginThirdDto.getThirdToken());
        return this.bindLoginProcess(userBindLoginThirdDto, userInfo);
    }

    @Override
    protected IAppSecretService getAppSecretService() {
        return this.appSecretService;
    }

    @Override
    protected IBindService getBindService() {
        return this.bindService;
    }

    @Override
    protected ITokenService getTokenService() {
        return this.tokenService;
    }

    @Override
    protected IVerifyCodeService getVerifyCodeService() {
        return this.verifyCodeService;
    }

    @Override
    protected IUserService getUserService() {
        return this.userService;
    }

    @Override
    protected IUserApi getUserApi() {
        return this.userApi;
    }

    @Override
    protected int getBindingLoginType(String type) {
        return 4;
    }

    @Override
    protected int getThirdType() {
        return 4;
    }
}

