/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.strategy.impl;

import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IAppSecretService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.strategy.AbstractThirdLoginHandler;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.query.ContainerCriteria;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ldapHandler")
public class LdapHandlerImpl
extends AbstractThirdLoginHandler {
    private static Logger logger = LoggerFactory.getLogger(LdapHandlerImpl.class);
    @Value(value="${identity.ldap.identity.attribute:uid}")
    private String identityAttribute;
    @Value(value="${identity.ldap.unique.attribute:uidNumber}")
    private String uniqueAttribute;
    @Resource
    private IAppSecretService appSecretService;
    @Resource
    private IBindService bindService;
    @Resource
    private ITokenService tokenService;
    @Resource
    private IVerifyCodeService verifyCodeService;
    @Resource
    private IUserService userService;
    @Resource
    private IUserApi userApi;
    @Autowired
    private LdapTemplate ldapTemplate;

    @Override
    protected int getThirdType() {
        return 8;
    }

    @Override
    public ThirdUserInfoRespDto thirdAuth(AuthLoginReqDto authLoginReqDto) {
        return null;
    }

    @Override
    public ThirdLoginRespDto tokenAuth(AuthLoginTokenReqDto authLoginTokenReqDto) {
        return null;
    }

    @Override
    public TokenRespDto bindLogin(UserBindLoginThirdDto userBindLoginThirdDto) {
        UserInfo userInfo;
        Assert.hasText((String)userBindLoginThirdDto.getUserName(), (String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)userBindLoginThirdDto.getPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (this.ldapTemplate == null) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.LDAP_CONFIG_NOT_EXISTS);
        }
        EqualsFilter filter = new EqualsFilter(this.identityAttribute, userBindLoginThirdDto.getUserName());
        this.ldapTemplate.setIgnorePartialResultException(true);
        boolean result = this.ldapTemplate.authenticate("", filter.toString(), userBindLoginThirdDto.getPassword());
        if (!result) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.USER_NAME_OR_PASSWORD_ERROR);
        }
        if (StringUtils.isEmpty((Object)(userInfo = this.getUserInfo(userBindLoginThirdDto)).getOpenid())) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.GET_USER_INFO_FAIL);
        } else {
            userBindLoginThirdDto.setOpenId(userInfo.getOpenid());
        }
        return this.bindLoginProcess(userBindLoginThirdDto, userInfo);
    }

    private UserInfo getUserInfo(UserBindLoginThirdDto userBindLoginThirdDto) {
        ContainerCriteria query = LdapQueryBuilder.query().where(this.identityAttribute).is(userBindLoginThirdDto.getUserName());
        List attributesList = this.ldapTemplate.search((LdapQuery)query, (AttributesMapper)new AttributesMapper<Attributes>(){

            public Attributes mapFromAttributes(Attributes attributes) throws NamingException {
                return attributes;
            }
        });
        UserInfo userInfo = new UserInfo();
        if (!CollectionUtils.isEmpty((Collection)attributesList)) {
            for (Attributes attributes : attributesList) {
                Attribute attribute = attributes.get(this.uniqueAttribute);
                if (attribute == null) continue;
                try {
                    userInfo.setOpenid(attribute.get().toString());
                }
                catch (NamingException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        return userInfo;
    }

    @Override
    protected IAppSecretService getAppSecretService() {
        return this.appSecretService;
    }

    @Override
    protected IBindService getBindService() {
        return this.bindService;
    }

    @Override
    protected ITokenService getTokenService() {
        return this.tokenService;
    }

    @Override
    protected IVerifyCodeService getVerifyCodeService() {
        return this.verifyCodeService;
    }

    @Override
    protected IUserService getUserService() {
        return this.userService;
    }

    @Override
    protected IUserApi getUserApi() {
        return this.userApi;
    }

    @Override
    protected int getBindingLoginType(String type) {
        return 8;
    }
}

