/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IAppSecretService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.dao.eo.AppSecretEo;
import com.dtyunxi.yundt.cube.center.identity.strategy.AbstractThirdLoginHandler;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.WeiXinUtil;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserEmployeeQueryRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="qyWeChatHandler")
public class QyWeChatHandlerImpl
extends AbstractThirdLoginHandler {
    private static final Logger logger = LoggerFactory.getLogger(QyWeChatHandlerImpl.class);
    @Resource
    private IAppSecretService appSecretService;
    @Resource
    private IBindService bindService;
    @Resource
    private ITokenService tokenService;
    @Resource
    private IVerifyCodeService verifyCodeService;
    @Resource
    private IUserService userService;
    @Resource
    private IUserApi userApi;
    @Autowired
    private ICacheService cacheService;
    @Resource
    private IUserQueryApi userQueryApi;

    @Override
    public ThirdUserInfoRespDto thirdAuth(AuthLoginReqDto authLoginReqDto) {
        AppSecretEo appSecretByFilter = this.createAppSecreteEo(authLoginReqDto);
        ThirdUserInfoRespDto thirdUserInfoRespDto = new ThirdUserInfoRespDto();
        thirdUserInfoRespDto.setResultUrl(WeiXinUtil.getQyOAuthCodeUrl(appSecretByFilter.getKeyAppId(), authLoginReqDto.getRedirectUri(), "snsapi_base", authLoginReqDto.getState()));
        return thirdUserInfoRespDto;
    }

    @Override
    public ThirdLoginRespDto tokenAuth(AuthLoginTokenReqDto authLoginTokenReqDto) {
        JSONObject jsonObject;
        AppSecretEo appSecretEo = this.createAppSecreteEo(authLoginTokenReqDto);
        String cacheKey = "secret" + appSecretEo.getKeyAppSecret();
        Authorization qyAuthorization = (Authorization)this.cacheService.getCache(cacheKey, Authorization.class);
        if (Objects.isNull(qyAuthorization)) {
            qyAuthorization = WeiXinUtil.getQyAuthorization(appSecretEo.getKeyAppId(), appSecretEo.getKeyAppSecret());
            this.setAccessTokenCache(cacheKey, qyAuthorization);
        }
        if (Objects.isNull(jsonObject = WeiXinUtil.getQyUserId(qyAuthorization.getAccessToken(), authLoginTokenReqDto.getCode()))) {
            qyAuthorization = WeiXinUtil.getQyAuthorization(appSecretEo.getKeyAppId(), appSecretEo.getKeyAppSecret());
            this.setAccessTokenCache(cacheKey, qyAuthorization);
            jsonObject = WeiXinUtil.getQyUserId(qyAuthorization.getAccessToken(), authLoginTokenReqDto.getCode());
        }
        if (Objects.isNull(jsonObject)) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.CODE_EXPIRE);
        }
        UserInfo userInfo = new UserInfo();
        Long bocuserId = null;
        if (Objects.nonNull(jsonObject.getString("UserId"))) {
            String userId = jsonObject.getString("UserId");
            JSONObject qyUserInfo = WeiXinUtil.getQyUserInfo(qyAuthorization.getAccessToken(), userId);
            bocuserId = this.check(qyUserInfo.getString("mobile"), authLoginTokenReqDto.getInstanceId());
            if (Objects.isNull(bocuserId)) {
                IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.USER_NO_EXIST);
            }
            String qyOpenId = WeiXinUtil.getQyOpenId(qyAuthorization.getAccessToken(), userId);
            userInfo.setOpenid(qyOpenId);
        } else {
            String openId = jsonObject.getString("OpenId");
            String userId = WeiXinUtil.getQyUserIdByOpenId(qyAuthorization.getAccessToken(), openId);
            JSONObject qyUserInfo = WeiXinUtil.getQyUserInfo(qyAuthorization.getAccessToken(), userId);
            bocuserId = this.check(qyUserInfo.getString("mobile"), authLoginTokenReqDto.getInstanceId());
            if (Objects.isNull(bocuserId)) {
                IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.USER_NO_EXIST);
            }
            userInfo.setOpenid(openId);
        }
        UserDto userDto = (UserDto)this.userQueryApi.queryById(bocuserId, null).getData();
        logger.info("userDto==>" + JSON.toJSONString((Object)userDto));
        if (userDto == null) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.USER_NO_EXIST);
        } else {
            if (userDto.getStatus() != null && userDto.getStatus() != 1) {
                IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.USER_DISABLE);
            }
            if (userDto.getActiveState() != null && userDto.getActiveState() != 1) {
                IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.USER_FREEZE);
            }
        }
        return this.createToken(userDto, authLoginTokenReqDto.getValidTime(), userInfo.getOpenid(), authLoginTokenReqDto.getThirdType(), qyAuthorization.getSessionKey());
    }

    @Override
    public TokenRespDto bindLogin(UserBindLoginThirdDto userBindLoginThirdDto) {
        UserInfo userInfo = new UserInfo();
        userInfo.setOpenid(userBindLoginThirdDto.getOpenId());
        return this.bindLoginProcess(userBindLoginThirdDto, userInfo);
    }

    private Long check(String phone, Long instanceId) {
        Long userId = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("phone", phone);
        map.put("instanceId", instanceId);
        PageInfo data = (PageInfo)this.userQueryApi.queryPageByUserAndEmployeeInfo(JSON.toJSONString(map), Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (CollectionUtils.isNotEmpty((Collection)data.getList())) {
            UserEmployeeQueryRespDto userEmployeeQueryRespDto = (UserEmployeeQueryRespDto)data.getList().get(0);
            userId = userEmployeeQueryRespDto.getId();
        }
        logger.info("\u7528\u6237\u624b\u673a\u53f7==>" + phone + " instanceId==>" + instanceId + " \u67e5\u8be2\u540e\u7684boc\u7528\u6237id==>" + userId);
        return userId;
    }

    @Override
    protected IAppSecretService getAppSecretService() {
        return this.appSecretService;
    }

    @Override
    protected IBindService getBindService() {
        return this.bindService;
    }

    @Override
    protected ITokenService getTokenService() {
        return this.tokenService;
    }

    @Override
    protected IVerifyCodeService getVerifyCodeService() {
        return this.verifyCodeService;
    }

    @Override
    protected IUserService getUserService() {
        return this.userService;
    }

    @Override
    protected IUserApi getUserApi() {
        return this.userApi;
    }

    @Override
    protected int getBindingLoginType(String type) {
        return 10;
    }

    @Override
    protected int getThirdType() {
        return 10;
    }

    private void setAccessTokenCache(String cacheKey, Authorization qyAuthorization) {
        if (Objects.nonNull(qyAuthorization)) {
            this.cacheService.setCache(cacheKey, (Object)qyAuthorization, qyAuthorization.getExpiresIn().intValue());
        }
    }
}

