/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.strategy.impl;

import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.constants.LoginSource;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IAppSecretService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.dao.eo.AppSecretEo;
import com.dtyunxi.yundt.cube.center.identity.strategy.AbstractThirdLoginHandler;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.WeiXinUtil;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="weChatHandler")
public class WeChatHandlerImpl
extends AbstractThirdLoginHandler {
    @Resource
    private IAppSecretService appSecretService;
    @Resource
    private IBindService bindService;
    @Resource
    private ITokenService tokenService;
    @Resource
    private IVerifyCodeService verifyCodeService;
    @Resource
    private IUserService userService;
    @Resource
    private IUserApi userApi;

    @Override
    public ThirdUserInfoRespDto thirdAuth(AuthLoginReqDto authLoginReqDto) {
        AppSecretEo appSecretByFilter = this.createAppSecreteEo(authLoginReqDto);
        ThirdUserInfoRespDto thirdUserInfoRespDto = new ThirdUserInfoRespDto();
        if (LoginSource.WEB.equals(authLoginReqDto.getLoginSource())) {
            thirdUserInfoRespDto.setResultUrl(WeiXinUtil.getOAuthCodeUrl(appSecretByFilter.getKeyAppId(), authLoginReqDto.getRedirectUri(), "snsapi_login", authLoginReqDto.getState()));
        } else if (LoginSource.APP.equals(authLoginReqDto.getLoginSource())) {
            thirdUserInfoRespDto.setResultUrl(WeiXinUtil.getBrowseOAuthCodeUrl(appSecretByFilter.getKeyAppId(), authLoginReqDto.getRedirectUri(), "snsapi_userinfo", "STATE"));
        }
        return thirdUserInfoRespDto;
    }

    @Override
    public ThirdLoginRespDto tokenAuth(AuthLoginTokenReqDto authLoginTokenReqDto) {
        AppSecretEo appSecretEo = this.createAppSecreteEo(authLoginTokenReqDto);
        Authorization authorization = WeiXinUtil.getAuthorization(appSecretEo.getKeyAppId(), appSecretEo.getKeyAppSecret(), authLoginTokenReqDto.getCode());
        UserInfo userInfo = WeiXinUtil.getUserInfo(authorization.getOpenid(), authorization.getAccessToken());
        return this.tokenAuthProcess(authLoginTokenReqDto, authorization, userInfo);
    }

    @Override
    public TokenRespDto bindLogin(UserBindLoginThirdDto userBindLoginThirdDto) {
        UserInfo userInfo = WeiXinUtil.getUserInfo(userBindLoginThirdDto.getOpenId(), userBindLoginThirdDto.getThirdToken());
        return this.bindLoginProcess(userBindLoginThirdDto, userInfo);
    }

    @Override
    protected IAppSecretService getAppSecretService() {
        return this.appSecretService;
    }

    @Override
    protected IBindService getBindService() {
        return this.bindService;
    }

    @Override
    protected ITokenService getTokenService() {
        return this.tokenService;
    }

    @Override
    protected IVerifyCodeService getVerifyCodeService() {
        return this.verifyCodeService;
    }

    @Override
    protected IUserService getUserService() {
        return this.userService;
    }

    @Override
    protected IUserApi getUserApi() {
        return this.userApi;
    }

    @Override
    protected int getBindingLoginType(String type) {
        return 1;
    }

    @Override
    protected int getThirdType() {
        return 1;
    }
}

