/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.util.HttpClientUtil;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacebookOauthUtil {
    private static Logger logger = LoggerFactory.getLogger(FacebookOauthUtil.class);
    private static final String ACCESS_TOKEN_URL = "https://graph.facebook.com/v3.2/oauth/access_token";
    private static final String USER_URL = "https://graph.facebook.com/me";
    private static final String GET_CODE_URL = "https://www.facebook.com/v3.2/dialog/oauth?client_id=%s&redirect_uri=%s";

    public static Authorization getAccessToken(String appId, String appSecret, String code, String redirectUrl) {
        StringBuilder params = new StringBuilder();
        params.append(ACCESS_TOKEN_URL);
        params.append("?client_id=").append(appId);
        params.append("&client_secret=").append(appSecret);
        logger.info("FaceBook\u56de\u8c03URI:{}", (Object)redirectUrl);
        params.append("&redirect_uri=").append(redirectUrl);
        params.append("&code=").append(code);
        logger.info("===\u83b7\u53d6FaceBook\u6388\u6743\u4fe1\u606f getOauthToken url = {}", (Object)params.toString());
        String resultJson = HttpClientUtil.sendGet(params.toString(), null);
        logger.info("===\u83b7\u53d6FaceBook\u6388\u6743\u4fe1\u606f getOauthToken resultJson = {}", (Object)resultJson);
        JSONObject parseObject = JSON.parseObject((String)resultJson);
        if (resultJson.contains("error")) {
            logger.error("===\u83b7\u53d6Facebook\u6388\u6743\u4fe1\u606f getOauthToken resultJson = {}", (Object)resultJson);
            IdentityExceptionCode.throwBizException((String)String.valueOf(parseObject.getJSONObject("error").getString("code")), (String)String.valueOf(parseObject.getJSONObject("error").getString("message")));
        }
        Authorization authorization = new Authorization();
        authorization.setAccessToken(parseObject.getString("access_token"));
        authorization.setExpiresIn(parseObject.getInteger("expires_in"));
        return authorization;
    }

    public static UserInfo getUserInfo(String accessToken) {
        String fields = "id,name,birthday,gender,hometown,email,devices";
        StringBuilder params = new StringBuilder(USER_URL);
        params.append("?access_token=").append(accessToken);
        params.append("&fields=").append(fields);
        logger.info("===\u83b7\u53d6FaceBook\u7528\u6237\u4fe1\u606f ThirdUserInfoDto url = {}", (Object)params.toString());
        String resultJson = HttpClientUtil.sendGet(params.toString(), null);
        JSONObject jsonObject = JSON.parseObject((String)resultJson);
        if (resultJson.contains("error")) {
            logger.error("===\u83b7\u53d6Facebook\u6388\u6743\u4fe1\u606f getOauthToken resultJson = {}", (Object)resultJson);
            IdentityExceptionCode.throwBizException((String)String.valueOf(jsonObject.getJSONObject("error").getString("code")), (String)String.valueOf(jsonObject.getJSONObject("error").getString("message")));
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setOpenid((String)jsonObject.get((Object)"id"));
        userInfo.setNickname((String)jsonObject.get((Object)"name"));
        return userInfo;
    }

    public static String getAuthorizationCodeUrl(String appId, String redirectUrl, Map extFields) {
        String url = String.format(GET_CODE_URL, appId, redirectUrl);
        StringBuilder sb = new StringBuilder(url);
        if (null != extFields) {
            if (extFields.containsKey("state")) {
                sb.append("&state=");
                sb.append(extFields.get("state"));
            }
            if (extFields.containsKey("response_type")) {
                sb.append("&response_type=");
                sb.append(extFields.get("response_type"));
            }
            if (extFields.containsKey("scope")) {
                sb.append("&scope=");
                sb.append(extFields.get("scope"));
            }
        }
        return sb.toString();
    }
}

