/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.util.HttpClientUtil;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QqOauthUtil {
    private static Logger logger = LoggerFactory.getLogger(QqOauthUtil.class);
    private static final String GET_AUTHORIZATION_CODE_URL = "https://graph.qq.com/oauth2.0/authorize?response_type=code&client_id=%s&redirect_uri=%s&state=%s";
    private static final String GET_ACCESS_TOKEN_URL = "https://graph.qq.com/oauth2.0/token?grant_type=authorization_code&client_id=%s&client_secret=%s&code=%s&redirect_uri=%s";
    private static final String GET_OPENID_URL = "https://graph.qq.com/oauth2.0/me?access_token=%s";
    private static final String GET_USER_INFO_URL = "https://graph.qq.com/user/get_user_info?access_token=%s&oauth_consumer_key=%s&openid=%s";
    private static final String GET_UNIONID_URL = "https://graph.qq.com/oauth2.0/me?access_token=%s&unionid=1";

    public static String getAuthorizationCodeUrl(String appId, String redirectUrl, Map<String, Object> extFields) {
        String display;
        if (null == extFields || StringUtils.isEmpty((CharSequence)((String)extFields.get("state")))) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_STATE_PARAM_ERROR);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(GET_AUTHORIZATION_CODE_URL, appId, QqOauthUtil.urlEncodeUTF8(redirectUrl), (String)extFields.get("state")));
        String scope = (String)extFields.get("scope");
        if (StringUtils.isNotEmpty((CharSequence)scope)) {
            sb.append("&scope=");
            sb.append(scope);
        }
        if (StringUtils.isNotEmpty((CharSequence)(display = (String)extFields.get("display")))) {
            sb.append("&display=");
            sb.append(display);
        }
        return sb.toString();
    }

    public static Authorization getAccessToken(String appId, String appSecret, String authorizationCode, String redirectUrl) {
        String url = String.format(GET_ACCESS_TOKEN_URL, appId, appSecret, authorizationCode, QqOauthUtil.urlEncodeUTF8(redirectUrl));
        String resp = HttpClientUtil.sendGet(url, null);
        logger.info("resp={}", (Object)resp);
        QqOauthUtil.checkResp(resp, "access_token");
        Authorization authorization = new Authorization();
        List<String> params = Arrays.asList(resp.split("&"));
        authorization.setAccessToken(params.stream().filter(param -> param.contains("access_token")).findFirst().get().split("=")[1]);
        authorization.setExpiresIn(Integer.valueOf(params.stream().filter(param -> param.contains("expires_in")).findFirst().get().split("=")[1]));
        authorization.setRefreshToken(params.stream().filter(param -> param.contains("refresh_token")).findFirst().get().split("=")[1]);
        return authorization;
    }

    public static String getOpenId(String accessToken) {
        String url = String.format(GET_OPENID_URL, accessToken);
        String resp = HttpClientUtil.sendGet(url, null);
        logger.info("resp={}", (Object)resp);
        QqOauthUtil.checkResp(resp, "openid");
        String jsonStr = resp.substring(resp.indexOf("callback(") + "callback(".length(), resp.indexOf(")"));
        JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
        return jsonObj.getString("openid");
    }

    public static String getUnionId(String accessToken) {
        String url = String.format(GET_UNIONID_URL, accessToken);
        String resp = HttpClientUtil.sendGet(url, null);
        logger.info("resp={}", (Object)resp);
        QqOauthUtil.checkResp(resp, "unionid");
        String jsonStr = resp.substring(resp.indexOf("callback(") + "callback(".length(), resp.indexOf(")"));
        JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
        return jsonObj.getString("unionid");
    }

    public static UserInfo getUserInfo(String appId, String openId, String accessToken) {
        String url = String.format(GET_USER_INFO_URL, accessToken, appId, openId);
        String resp = HttpClientUtil.sendGet(url, null);
        JSONObject jsonObj = JSON.parseObject((String)resp);
        if (!"0".equals(jsonObj.getString("ret"))) {
            IdentityExceptionCode.throwBizException((String)jsonObj.getString("ret"), (String)jsonObj.getString("msg"));
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setNickname(jsonObj.getString("nickname"));
        userInfo.setSex(jsonObj.getString("sex"));
        StringBuilder sb = new StringBuilder();
        sb.append(jsonObj.getString("figureurl_qq_1"));
        sb.append(";");
        sb.append(jsonObj.getString("figureurl_qq_2"));
        userInfo.setHeadimgurl(sb.toString());
        return userInfo;
    }

    public static String urlEncodeUTF8(String str) {
        String result = str;
        try {
            result = URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception arg2) {
            arg2.printStackTrace();
        }
        return result;
    }

    private static void checkResp(String resp, String keyword) {
        if (StringUtils.isEmpty((CharSequence)resp)) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_RESP_BODY);
        }
        if (!resp.contains(keyword) && resp.contains("error")) {
            String jsonStr = resp.substring(resp.indexOf("callback(") + "callback(".length(), resp.indexOf(")"));
            JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
            IdentityExceptionCode.throwBizException((String)jsonObj.getString("error"), (String)jsonObj.getString("error_description"));
        }
    }
}

