/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.util;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.util.HttpClientUtil;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinaOauthUtil {
    private static Logger logger = LoggerFactory.getLogger(SinaOauthUtil.class);
    private static final String GET_SINA_CODE_URL = "https://api.weibo.com/oauth2/authorize?client_id=%s&redirect_uri=%s";
    private static final String GET_SINA_TOKEN_URL = "https://api.weibo.com/oauth2/access_token";
    private static final String GET_SINA_USER_INFO_URL = "https://api.weibo.com/2/users/show.json?access_token=%s&uid=%s";

    public static String getAuthorizationCodeUrl(String appId, String redirectUrl, Map<String, Object> extFields) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(GET_SINA_CODE_URL, appId, SinaOauthUtil.urlEnodeUTF8(redirectUrl)));
        if (null != extFields) {
            if (extFields.containsKey("scope")) {
                sb.append("&scope=");
                sb.append(extFields.get("scope"));
            }
            if (extFields.containsKey("state")) {
                sb.append("&state=");
                sb.append(extFields.get("state"));
            }
            if (extFields.containsKey("display")) {
                sb.append("&display=");
                sb.append(extFields.get("display"));
            }
            if (extFields.containsKey("forcelogin")) {
                sb.append("&forcelogin=");
                sb.append(extFields.get("forcelogin"));
            }
            if (extFields.containsKey("language")) {
                sb.append("&language=");
                sb.append(extFields.get("language"));
            }
        }
        return sb.toString();
    }

    public static Authorization getAccessToken(String appId, String appSecret, String code, String redirectUrl) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", appId);
        params.put("client_secret", appSecret);
        params.put("grant_type", "authorization_code");
        params.put("code", code);
        params.put("redirect_uri", redirectUrl);
        String resultJson = HttpClientUtil.sendPost(GET_SINA_TOKEN_URL, params, null);
        if (StringUtils.isEmpty((CharSequence)resultJson)) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_RESP_BODY);
        }
        JSONObject jsonObj = JSONObject.parseObject((String)resultJson);
        if (resultJson.contains("error_code")) {
            IdentityExceptionCode.throwBizException((String)jsonObj.getString("error_code"), (String)jsonObj.getString("error"));
        }
        Authorization authorization = new Authorization();
        authorization.setAccessToken(jsonObj.getString("access_token"));
        authorization.setExpiresIn(jsonObj.getIntValue("expires_in"));
        authorization.setOpenid(jsonObj.getString("uid"));
        return authorization;
    }

    public static UserInfo getUserInfo(String uid, String accessToken) {
        String url = String.format(GET_SINA_USER_INFO_URL, accessToken, uid);
        String resultJson = HttpClientUtil.sendGet(url, null);
        if (StringUtils.isEmpty((CharSequence)resultJson)) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_RESP_BODY);
        }
        if (resultJson.contains("error_code")) {
            JSONObject jsonObj = JSON.parseObject((String)resultJson);
            IdentityExceptionCode.throwBizException((String)jsonObj.getString("error_code"), (String)jsonObj.getString("error"));
        }
        JSONObject jsonObject = JSON.parseObject((String)resultJson);
        UserInfo userInfo = new UserInfo();
        userInfo.setNickname(jsonObject.getString("screen_name"));
        userInfo.setSex(jsonObject.getString("gender"));
        userInfo.setHeadimgurl("profile_image_url");
        return userInfo;
    }

    public static String urlEnodeUTF8(String str) {
        String result = str;
        try {
            result = URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception arg2) {
            arg2.printStackTrace();
        }
        return result;
    }
}

