/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.util.weixin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.dtyunxi.util.HttpUtil;
import com.dtyunxi.util.WeiXinApi;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.util.JsonUtil;
import com.dtyunxi.yundt.cube.center.identity.util.weixin.Authorization;
import java.net.URLEncoder;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WeiXinUtil {
    private static Logger logger = LoggerFactory.getLogger(WeiXinUtil.class);
    public static final String QY_WEIXIN_ACCESS_TOKEN = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=CORPID&corpsecret=SECRECT";
    public static final String QY_WEIXIN_GETUSERINFO = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN&userid=USERID";
    public static final String QY_WEIXIN_USERINFO_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo?access_token=ACCESS_TOKEN&code=CODE";
    public static final String QY_CONVERT_TO_OPENID_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_openid?access_token=ACCESS_TOKEN";
    public static final String QY_CONVERT_TO_USERID_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_userid?access_token=ACCESS_TOKEN";
    public static final String ACCESS_TOKEN_INVALID = "42001";
    public static final String QY_WEIXIN_SUCCESS = "0";

    public static Authorization getAuthorization(String appId, String appSecret, String code) {
        String json = HttpUtil.sendGet((String)WeiXinApi.getOAuthTokenUrl((String)appId, (String)appSecret, (String)code));
        Authorization authorization = JsonUtil.toObject(json, new TypeReference<Authorization>(){});
        return authorization;
    }

    public static Authorization getMPAuthorization(String url) {
        String json = HttpUtil.sendGet((String)url);
        return (Authorization)JSON.parseObject((String)json, Authorization.class);
    }

    public static UserInfo getUserInfo(String openid, String token) {
        String ticketJson = HttpUtil.sendGet((String)WeiXinApi.getOAuthUserinfoUrl((String)token, (String)openid));
        logger.info("WX UserInfo==>>>{}", (Object)ticketJson);
        UserInfo userInfo = JsonUtil.toObject(ticketJson, new TypeReference<UserInfo>(){});
        return userInfo;
    }

    public static String getOAuthCodeUrl(String APPID, String redirectUrl, String scope, String state) {
        return String.format("https://open.weixin.qq.com/connect/qrconnect?appid=%s&redirect_uri=%s&response_type=%s&scope=%s&state=%s#wechat_redirect", APPID, WeiXinUtil.urlEnodeUTF8(redirectUrl), "code", scope, state);
    }

    public static String getBrowseOAuthCodeUrl(String APPID, String redirectUrl, String scope, String state) {
        return String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s&connect_redirect=1#wechat_redirect", APPID, WeiXinUtil.urlEnodeUTF8(redirectUrl), scope, state);
    }

    public static String getQyOAuthCodeUrl(String APPID, String redirectUrl, String scope, String state) {
        return String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=%s&scope=%s&state=%s#wechat_redirect", APPID, WeiXinUtil.urlEnodeUTF8(redirectUrl), "code", scope, state);
    }

    public static Authorization getQyAuthorization(String appId, String appSecret) {
        String requestUrl = QY_WEIXIN_ACCESS_TOKEN.replace("CORPID", appId).replace("SECRECT", appSecret);
        String json = HttpUtil.sendGet((String)requestUrl);
        Authorization authorization = JsonUtil.toObject(json, new TypeReference<Authorization>(){});
        return authorization;
    }

    public static JSONObject getQyUserId(String accessToken, String code) {
        String requestUrl = QY_WEIXIN_USERINFO_URL.replace("ACCESS_TOKEN", accessToken).replace("CODE", code);
        String json = HttpUtil.sendGet((String)requestUrl);
        logger.info("WX getQyUserId==>>>{}", (Object)json);
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if (!QY_WEIXIN_SUCCESS.equals(jsonObject.getString("errcode"))) {
            return null;
        }
        return jsonObject;
    }

    public static JSONObject getQyUserInfo(String accessToken, String userId) {
        String requestUrl = QY_WEIXIN_GETUSERINFO.replace("ACCESS_TOKEN", accessToken).replace("USERID", userId);
        String ticketJson = HttpUtil.sendGet((String)requestUrl);
        logger.info("WX QyUserInfo==>>>{}", (Object)ticketJson);
        JSONObject jsonObject = JSONObject.parseObject((String)ticketJson);
        if (!QY_WEIXIN_SUCCESS.equals(jsonObject.getString("errcode"))) {
            return null;
        }
        return jsonObject;
    }

    public static String getQyOpenId(String accessToken, String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userid", userId);
        String requestUrl = QY_CONVERT_TO_OPENID_URL.replace("ACCESS_TOKEN", accessToken);
        String json = HttpUtil.sendPost((String)requestUrl, (String)JSON.toJSONString(map));
        logger.info("WX getQyOpenId==>>>{}", (Object)json);
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if (!QY_WEIXIN_SUCCESS.equals(jsonObject.getString("errcode"))) {
            return null;
        }
        return String.valueOf(jsonObject.getString("openid"));
    }

    public static String getQyUserIdByOpenId(String accessToken, String openId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openid", openId);
        String requestUrl = QY_CONVERT_TO_USERID_URL.replace("ACCESS_TOKEN", accessToken);
        String json = HttpUtil.sendPost((String)requestUrl, (String)JSON.toJSONString(map));
        logger.info("WX getQyUserIdByOpenId==>>>{}", (Object)json);
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if (!QY_WEIXIN_SUCCESS.equals(jsonObject.getString("errcode"))) {
            return null;
        }
        return String.valueOf(jsonObject.getString("userid"));
    }

    public static String urlEnodeUTF8(String str) {
        String result = str;
        try {
            result = URLEncoder.encode(str);
        }
        catch (Exception arg2) {
            arg2.printStackTrace();
        }
        return result;
    }
}

