package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryChangeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteRecordReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderRouteRuleRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 发货单路由api
 *
 * @author: fuyun
 * @Date: 2020/9/4 17:17
 */
@Api(tags = {"库存中心：路由服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/delivery/route"
)
public interface DeliveryRouteApi {

    /**
     * 根据发货单号进行路由
     *
     * @param deliveryNo
     */
    @GetMapping(value = "/route")
    @ApiOperation(value = "根据发货单号进行路由", notes = "根据发货单号进行路由")
    RestResponse<Void> route(@RequestParam(value = "deliveryNo") String deliveryNo);

    /**
     * 保存路由记录
     *
     * @param deliveryRouteRecordReqDto 记录数据
     * @return
     */
    @PostMapping(value = "/saveRouteRecord")
    @ApiOperation(value = "保存路由记录", notes = "保存路由记录")
    RestResponse<Void> saveRouteRecord(@RequestBody DeliveryRouteRecordReqDto deliveryRouteRecordReqDto);

    /**
     * 发货单实时变更接口
     *
     * @param deliveryChangeReqDto
     * @return
     */
    @PostMapping(value = "/change")
    @ApiOperation(value = "发货单实时变更", notes = "发货单实时变更")
    RestResponse<Void> change(@RequestBody DeliveryChangeReqDto deliveryChangeReqDto);
}