package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageShareDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 异步货品库存共享api
 *
 * @Interface IAsynCargoStorageShareApi
 * @Author chunjiu
 * @Date 2020/9/12 14:55
 */
@Api(tags = {"库存中心：异步货品库存共享"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/task")
public interface IAsynCargoStorageShareApi {
    /**
     * 异步生成货品库存共享任务单：在新增逻辑仓和共享仓时，设置共享货品，查询到货品数量超多阈值，会调用该接口步生成货品库存共享任务单
     *
     * @param shareDto 共享设置参数
     * @return boolean  true：成功；false：失败
     **/
    @PostMapping("")
    @ApiOperation(value = "异步创建共享任务", notes = "异步创建共享任务")
    boolean asynCreateShareTask(@Valid @RequestBody CargoStorageShareDto shareDto);
}
