package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.BillCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.BillReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


/**
* 库存单据服务接口
*/
@Api(tags = {"库存单据服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v1/bill"
)
public interface IBillApi {

    /**
    * 新增库存单据
    *
    * @param billReqDto 库存单据请求对象
    * @return 处理结果
    */
    @PostMapping("/add")
    @ApiOperation(value = "新增库存单据", notes = "新增库存单据")
    RestResponse<Long> addBill(@RequestBody BillCreateReqDto billReqDto);

    /**
    * 修改库存单据
    *
    * @param billReqDto 库存单据请求对象
    * @return 处理结果
    */
    @PutMapping("/modify")
    @ApiOperation(value = "修改库存单据", notes = "修改库存单据")
    RestResponse<Void> modifyBill(@RequestBody BillCreateReqDto billReqDto);

    /**
    * 删除库存单据
    *
    * @param ids        库存单据删除数据ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除库存单据", notes = "删除库存单据")
    RestResponse<Void> removeBill(@PathVariable("ids") String ids);


    /**
     * 审核单据
     * @param id
     * @return
     */
    @PutMapping(value = "/{id}/audit")
    @ApiOperation(value = "审核单据",notes = "审核单据")
    RestResponse<Void> auditBill(@PathVariable("id") Long id, @RequestParam("status") Integer status, @RequestParam(name = "name",required = false)String name);

}
