/*
 * ICargoApi.class 1.0 2018-08-31
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * 货品管理服务
 *
 * @author 纳兰
 * @since 2.0.0
 */
@Api(tags = {"库存中心：货品管理服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/cargo"
)
public interface ICargoApi {

    /**
     * 新建货品
     *
     * @param cargoCreateReqDto 货品创建Dto
     * @return 操作结果
     */
    @PostMapping(value = "addCargo")
    @ApiOperation(value = "新建货品", notes = "新建货品")
    RestResponse<Long> addCargo(@RequestBody CargoCreateReqDto cargoCreateReqDto);

    /**
     * 根据货品id修改货品信息
     *
     * @param cargoUpdateReqDto 仓库修改Dto
     * @return 返回统一响应对象
     */
    @PutMapping(value = "/modifyCargo")
    @ApiOperation(value = "根据货品id修改货品信息", notes = "根据货品id修改货品信息")
    RestResponse<Void> modifyCargo(@RequestBody CargoUpdateReqDto cargoUpdateReqDto);

    /**
     * 根据id删除货品信息
     *
     * @param id     货品id
     * @param filter 过滤条件，未启用
     * @return 返回统一响应对象
     */
    @DeleteMapping(value = "/{id}")
    @ApiOperation(value = "根据id删除货品信息", notes = "filter，未启用")
    RestResponse<Void> removeById(@NotNull(message = "货品ID不能为空") @PathVariable("id") Long id, @RequestParam("filter") String filter);

    /**
     * 根据code删除货品信息
     *
     * @param filter 过滤条件，未启用
     * @param code   货品编码
     * @return 返回统一响应对象
     */
    @DeleteMapping(value = "/code/{code}")
    @ApiOperation(value = "根据code删除货品信息", notes = "filter，未启用")
    RestResponse<Void> removeByCode(@NotNull(message = "货品code不能为空") @PathVariable("code") String code, @RequestParam("filter") String filter);

}
