/*
 * @(#)ICargoOrderDeliveryQueryApi.java 1.0 2018-11-06
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryOrderInfoReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 外部订单服务
 * @author 简树
 * @since 2.0.0
 */
@Api(tags = {"库存中心：外部订单服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/order/"
)
public interface ICargoOrderDeliveryApi {
    /**
     * 取消订单
     * @param tradeOrderNo 交易订单编号
     * @return 操作结果
     */
    @PutMapping("/order-no/{tradeOrderNo}/cancel")
    @ApiOperation(value = "根据交易订单编号取消订单", notes = "根据交易订单编号取消订单\n"
            + "1、更新发货单表、包裹表、出入库单据明细表的状态为CANCEL\n"
            + "2、恢复货品库存表和缓存的库存")
    RestResponse<Boolean> cancelByOrderNo(@PathVariable("tradeOrderNo") String tradeOrderNo);

    /**
     * 申请订单发货请求
     * @param tradeOrderNo 交易订单编号
     * @param deliveryOrderInfoReqDto 申请订单发货请求Dto
     * @return 操作结果
     */
    @PutMapping("/order-no/{tradeOrderNo}/delivery")
    @ApiOperation(value = "申请订单发货请求", notes = "申请订单发货请求")
    RestResponse<Boolean> deliverByOrderNo(@PathVariable("tradeOrderNo") String tradeOrderNo, @RequestBody DeliveryOrderInfoReqDto deliveryOrderInfoReqDto);

}
