/**
 * @(#) ICargoStorageApi.java 1.0 2018-09-03
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.storage.UpdateStorageSynNumReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 货品库存服务
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"库存中心：货品库存服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/cargo/storage"
)
public interface ICargoStorageApi {

    /**
     * 货品库存操作
     *
     * @param cargoStorageReqDto 货品扣减库存请求DTO
     * @return 操作结果
     */
    @PostMapping("")
    @ApiOperation(value = "货品库存扣减", notes = "先扣减缓存的货品库存，然后发送MQ异步扣减数据库的库存")
    RestResponse<Void> subCargoStorage(@Valid @RequestBody CargoStorageCreateReqDto cargoStorageReqDto);

    /**
     * 货品库存更新
     *
     * @param id                       货品库存ID
     * @param cargoStorageUpdateReqDto 业务参数封装
     * @return 操作结果
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "货品库存更新", notes = "如果CargoStorageUpdateReqDto.groupId不为空，id是货品库存表的主键id，更新货品库表的分组id\n"
            + "如果CargoStorageUpdateReqDto.status不为空，id是库存变更日志表的主键id，更新库存变更日志的状态")
    RestResponse<Void> modifyCargoStorage(@NotNull(message = "id不能为空") @PathVariable("id") Long id,
                                          @Valid @RequestBody CargoStorageUpdateReqDto cargoStorageUpdateReqDto);

    /**
     * 重置货品缓存数据
     *
     * @param cargoStorageRestReqDto 货品缓存重置请求Dto
     * @return 操作结果
     */
    @PostMapping("/rest")
    @ApiOperation(value = "重新计算redis中的货品缓存数据，如果缓存数据存在则不更新", notes = "避免出现redis数据被清空查询不到缓存的情况")
    RestResponse<Void> resetCargoStorage(@RequestBody CargoStorageRestReqDto cargoStorageRestReqDto);

    /**
     * 库存覆盖
     *
     */
    @PostMapping("/cover")
    @ApiOperation(value = "库存覆盖")
    RestResponse<Void> coverCargoStorage(@RequestBody StorageAdjustCoverReqDto storageAdjustCoverReqDto);



    @PostMapping("/confirm")
    @ApiOperation(value = "确认")
    RestResponse<Void> confirmPreempt(@RequestBody CargoStoragePreemptConfirmReqDto preemptConfirmReqDto);

    @PostMapping("/update/syn/num")
    @ApiOperation(value = "更新营销云同步过来的数量")
    RestResponse<Void> updateStorageSynNum(@RequestBody List<UpdateStorageSynNumReqDto> synStorageUpdateNumReqDtoList);


}
