package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ChangeLogReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
* 库存流水服务接口
*/
@Api(tags = {"库存流水服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/changeLog"
)
public interface IChangeLogApi {

    /**
    * 新增库存流水
    *
    * @param changeLogDto 库存流水请求对象
    * @return 处理结果
    */
    @PostMapping("/add")
    @ApiOperation(value = "新增库存流水", notes = "新增库存流水")
    RestResponse<Long> addChangeLog(@RequestBody ChangeLogReqDto changeLogDto);

    /**
    * 修改库存流水
    *
    * @param changeLogDto 库存流水请求对象
    * @return 处理结果
    */
    @PutMapping("/modify")
    @ApiOperation(value = "修改库存流水", notes = "修改库存流水")
    RestResponse<Void> modifyChangeLog(@RequestBody ChangeLogReqDto changeLogDto);

    /**
    * 删除库存流水
    *
    * @param ids        库存流水删除数据ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除库存流水", notes = "删除库存流水")
    RestResponse<Void> removeChangeLog(@PathVariable("ids") String ids);

}
