/**
 * @(#) IDeliveryOrderApi.java 1.0 2018-08-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryOrderGenerateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 发货单服务
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"库存中心：发货单服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/delivery-order"
)
public interface IDeliveryOrderApi {

    /**
     * 生成发货单
     *
     * @param deliveryOrderJson 交易中心发送生成发货单的JSON
     */
    @PostMapping("/generateDelivery")
    @ApiOperation(value = "根据交易中心发送的JSON生成发货单", notes = "根据交易中心发送的JSON生成发货单")
    RestResponse<Void> generateDelivery(@RequestBody String deliveryOrderJson);


    @PostMapping("/newGenerateDelivery")
    @ApiOperation(value = "新接口-根据交易中心发送的JSON生成发货单", notes = "根据交易中心发送的JSON生成发货单")
    RestResponse<Void> generateDelivery(@Valid @RequestBody DeliveryOrderGenerateReqDto deliveryOrderGenerateReqDto);

}
