package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.DiffOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.DiffOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.DiffOrderDetailModifyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.DiffOrderModifyReqDto;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 收发差异单服务接口
 *
 * @author qiuzhi
 * @since 2021-05-24
 */
@Api(tags = {"库存中心：收发差异单服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IDiffOrderApi",
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/diff-order"
)
public interface IDiffOrderApi {

    /**
     * 新增收发差异单
     *
     * @param reqDto 收发差异单添加请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增收发差异单", notes = "新增收发差异单")
    RestResponse<Long> addDiffOrder(@RequestBody DiffOrderAddReqDto reqDto);

    /**
     * 修改收发差异单
     *
     * @param reqDto 收发差异单修改请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改收发差异单", notes = "修改收发差异单")
    RestResponse<Void> modifyDiffOrder(@RequestBody DiffOrderModifyReqDto reqDto);

    /**
     * 删除收发差异单
     *
     * @param ids        收发差异单删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("{ids}")
    @ApiOperation(value = "删除收发差异单", notes = "删除收发差异单")
    RestResponse<Void> removeDiffOrder(@PathVariable("ids") String ids);

    /**
     * 新增收发差异单明细
     *
     * @param reqDto 收发差异单明细添加请求对象
     * @return 处理结果
     */
    @PostMapping("/detail")
    @ApiOperation(value = "新增收发差异单明细", notes = "新增收发差异单明细")
    RestResponse<Long> addDiffOrderDetail(@RequestBody DiffOrderDetailAddReqDto reqDto);

    /**
     * 修改收发差异单明细
     *
     * @param reqDto 收发差异单明细修改请求对象
     * @return 处理结果
     */
    @PutMapping("/detail")
    @ApiOperation(value = "修改收发差异单明细", notes = "修改收发差异单明细")
    RestResponse<Void> modifyDiffOrderDetail(@RequestBody DiffOrderDetailModifyReqDto reqDto);

    /**
     * 删除收发差异单明细
     *
     * @param ids        收发差异单明细删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/detail/{ids}")
    @ApiOperation(value = "删除收发差异单明细", notes = "删除收发差异单明细")
    RestResponse<Void> removeDiffOrderDetail(@PathVariable("ids") String ids);
}
