package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.OrderRouteRuleReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * @author: liuji
 * @Date: 2020-06-22 11:11
 * @since 2.0.0
 */
@Api(tags = {"库存中心：订单路由规则服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/shop/route/rule"
)
public interface IOrderRouteRuleApi {

    /**
     * 新增/编辑订单路由规则
     * @return
     */
    @PostMapping("/save")
    @ApiOperation(value = "新增/编辑订单路由规则", notes = "新增/编辑订单路由规则")
    RestResponse<String> saveRouteRule(@Valid @RequestBody OrderRouteRuleReqDto orderRouteRuleReqDto);


    /**
     * 启用/禁用订单路由规则
     * @param id
     * @param status 订单路由规则状态（0 启用，1 禁用）
     * @return
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "根据主键id和状态启用/禁用订单路由规则", notes = "根据主键id和状态启用/禁用订单路由规则")
    RestResponse<String> enOrDisableRouteRule(@PathVariable("id") Long id, @RequestParam("status") Integer status);
}
