/*
 * @(#)IRServiceAreaApi.java 1.0 2018-11-09
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RServiceAreaReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 服务区和区域关联 api
 *
 * @author 简树
 * @since 2.0.0
 */

@Api(tags = {"库存中心：仓库管理服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v1/inventory"
)
public interface IRServiceAreaApi {
    @PostMapping("/service_area")
    @ApiOperation(value = "新增服务区和区域关联", notes = "服务区和区域关联")
    RestResponse<Long> add(@Valid @RequestBody RServiceAreaReqDto rServiceAreaReqDto);

}
