package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RefWarehouseReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
* 仓库关联表服务接口
*/
@Api(tags = {"仓库关联表服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v1/refWarehouse"
)
public interface IRefWarehouseApi {

    /**
    * 新增仓库关联表
    *
    * @param RefWarehouseReqDto 仓库关联表请求对象
    * @return 处理结果
    */
    @PostMapping("/add")
    @ApiOperation(value = "新增仓库关联表", notes = "新增仓库关联表")
    RestResponse<Long> addRefWarehouse(@RequestBody List<RefWarehouseReqDto> RefWarehouseReqDto);

    /**
    * 修改仓库关联表
    *
    * @param RefWarehouseReqDto 仓库关联表请求对象
    * @return 处理结果
    */
    @PutMapping("/modify")
    @ApiOperation(value = "修改仓库关联表", notes = "修改仓库关联表")
    RestResponse<Void> modifyRefWarehouse(@RequestBody List<RefWarehouseReqDto> RefWarehouseReqDto);

    /**
    * 删除仓库关联表
    *
    * @param ids        仓库关联表删除数据ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除仓库关联表", notes = "删除仓库关联表")
    RestResponse<Void> removeRefWarehouse(@PathVariable("ids") String ids);

}
