package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RuleReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
* 库存规则服务接口
*/
@Api(tags = {"库存规则服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/rule"
)
public interface IRuleApi {

    /**
    * 新增库存规则
    *
    * @param ruleDto 库存规则请求对象
    * @return 处理结果
    */
    @PostMapping("/add")
    @ApiOperation(value = "新增库存规则", notes = "新增库存规则")
    RestResponse<Long> addRule(@RequestBody RuleReqDto ruleDto);

    /**
    * 修改库存规则
    *
    * @param ruleDto 库存规则请求对象
    * @return 处理结果
    */
    @PutMapping("/modify")
    @ApiOperation(value = "修改库存规则", notes = "修改库存规则")
    RestResponse<Void> modifyRule(@RequestBody RuleReqDto ruleDto);

    /**
    * 删除库存规则
    *
    * @param ids        库存规则删除数据ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除库存规则", notes = "删除库存规则")
    RestResponse<Void> removeRule(@PathVariable("ids") String ids);

}
