package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustCoverReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 库存调整服务接口
 * @author: liuji
 * @Date: 2020-07-20 10:20
 * @since 2.0.0
 */
@Api(tags = {"库存中心：库存调整服务接口"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/storage/adjust"
)
public interface IStorageAdjustApi {

    /**
     * 增加库存调整
     * @return
     */
    @PostMapping
    @ApiOperation(value = "增加库存调整信息",notes = "增加库存调整信息")
    RestResponse<String> addStorageAdjust(@RequestBody @Valid StorageAdjustReqDto storageAdjustReqDto);

    /**
     * 根据ID修改库存调整信息
     * @param id
     * @return
     */
    @PutMapping(value = "/{id}")
    @ApiOperation(value = "根据ID修改库存调整信息",notes = "根据ID修改库存调整信息")
    RestResponse<Void> modifyStorageAdjust(@PathVariable("id") Long id,
                                           @Valid @RequestBody StorageAdjustReqDto storageAdjustReqDto);

    /**
     * 提交库存调整
     * @param id
     * @return
     */
    @PutMapping(value = "/{id}/commit")
    @ApiOperation(value ="提交库存调整",notes = "提交库存调整")
    RestResponse<Void> commitStorageAdjust(@PathVariable("id") Long id);

    /**
     * 审核库存调整
     * @param id
     * @return
     */
    @PutMapping(value = "/{id}/audit")
    @ApiOperation(value = "审核库存调整",notes = "审核库存调整")
    RestResponse<Void> auditStorageAdjust(@PathVariable("id") Long id,
                                          @Valid @RequestBody StorageAdjustAuditReqDto storageAdjustAuditReqDto);
    @PutMapping(value = "/cover")
    @ApiOperation(value = "审核库存调整",notes = "审核库存调整")
    RestResponse<Void> storageAdjustCover(@Valid @RequestBody StorageAdjustCoverReqDto storageAdjustCoverReqDto);
}
