package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageObjectReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author: liuji
 * @Date: 2020-07-03 11:01
 * @since 2.0.0
 */
@Api(tags = {"库存中心：库存对象服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/storage/object"
)
public interface IStorageObjectApi {

    /**
     * 新增/编辑库存对象
     * @param storageObjectReqDto
     * @return
     */
    @PostMapping("/save")
    @ApiOperation(value = "新增/编辑库存对象", notes = "新增/编辑库存对象")
    RestResponse<String> saveStorageObject(@Valid @RequestBody StorageObjectReqDto storageObjectReqDto);

}
