/*
 * @(#)StorageOrderApi.java 1.0 2018-08-30
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderCreateDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.storage.*;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageCheckRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDetailDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * 出库单/入库单增删改接口
 *
 * @author 书生
 * @since 2.0.0
 */
@Api(tags = {"库存中心：入库/出库服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/storage")
public interface IStorageOrderApi {

    /**
     * 新增出入库单
     * <p>
     * StorageOrderCreateDto为组合对象，包含 StorageOrderReqDto、StorageOrderDetailReqDto
     * warehouseId、type、tenant_id、instance_id为非空
     * <p>
     * </p>
     *
     * @param dto 出/入库新增的参数
     * @return Long 返回出入库单据表ID
     */
    @PostMapping("/add")
    @ApiOperation(value = "新增入库/出库单", notes = "同步修改数据库和缓存的总库存balance")
    RestResponse<Long> addStorageOrder(@Valid @RequestBody StorageOrderCreateDto dto);

    /**
     * 修改出入库单据
     * <p>
     * StorageOrderCreateDto为组合对象，包含 StorageOrderReqDto、StorageOrderDetailReqDto
     * warehouseId、type、tenant_id、instance_id为非空
     * <p>
     * </p>
     *
     * @param storageOrderReqDto 出入库新增的参数
     */
    @PostMapping("/modify")
    @ApiOperation(value = "修改出入库单据", notes = "同步修改数据库和缓存的总库存balance")
    RestResponse<Void> modifyStorageOrder(@RequestBody StorageOrderCreateDto storageOrderReqDto);

    /**
     * 审核出入库单

     */
    @PutMapping(value = "/{id}/audit")
    @ApiOperation(value = "审核出入库单",notes = "审核出入库单")
    RestResponse<Void> auditStorageOrder(@PathVariable("id") Long id,@RequestParam("status") Integer status,@RequestParam(name = "name",required = false)String name);

    @PutMapping(value = "/cancel-out-storage")
    @ApiOperation(value = "取消出库单",notes = "取消出库单")
    RestResponse<Void> cancelOutStorageOrder(@RequestBody OutStorageCancelReqDto reqDto);

    @PutMapping("/out-storage/out")
    @ApiOperation(value = "出库单出库",notes = "出库单出库")
    RestResponse<Void> outStorageOrder(@RequestBody OutStorageOutReqDto reqDto);


    @PutMapping("/out-storage/deliver")
    @ApiOperation(value = "出库单发货",notes = "出库单发货")
    RestResponse<List<StorageCheckRespDto>> deliverStorageOrder(@RequestBody DeliverStorageReqDto reqDto);

    @PutMapping(value = "/cancel-in-storage")
    @ApiOperation(value = "取消入库单",notes = "取消入库单")
    RestResponse<Void> cancelInStorageOrder(@RequestBody InStorageCancelReqDto reqDto);

    @PutMapping("/in-storage/in")
    @ApiOperation(value = "入库单入库",notes = "入库单入库")
    RestResponse<Void> inStorageOrder(@RequestBody InStorageInReqDto reqDto);

    /**
     * 因in_delivery_order表和in_delivery_order_detail表废除,移除相关代码,此接口逻辑可能不正确
     */
    @Deprecated
    @PostMapping("/package/cargo")
    @ApiOperation(value = "通过包裹和货品新增出库单", notes = "通过包裹和货品新增出库单")
    RestResponse<Long> addStorageOrderByPackageAndCargo(@RequestBody List<PackageDetailDto> packageDetailDtoList);
}
