package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.TcbjStockChangeDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderModifyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageCheckRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 服务接口
 *
 * @author qiuzhi
 * @since 2021-05-21
 */
@Api(tags = {"库存中心：调拨单服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ITransferOrderApi",
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/transfer-order"
)
public interface ITransferOrderApi {

    /**
     * 新增
     *
     * @param reqDto 添加请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增调拨单", notes = "新增调拨单")
    RestResponse<Long> addTransferOrder(@RequestBody TransferOrderAddReqDto reqDto);

    /**
     * 修改
     *
     * @param reqDto 修改请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改调拨单", notes = "修改调拨单")
    RestResponse<Void> modifyTransferOrder(@RequestBody TransferOrderModifyReqDto reqDto);

    /**
     * 删除
     *
     * @param ids 删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除调拨单", notes = "删除调拨单")
    RestResponse<Void> removeTransferOrder(@PathVariable("ids") String ids);


    @PutMapping("/cancel")
    @ApiOperation(value = "取消调拨单", notes = "取消调拨单")
    RestResponse<Void> cancelTransferOrder(@RequestBody TransferOrderCancelReqDto reqDto);

    /**
     * 审核调拨单
     *
     * @return
     */
    @PutMapping("/audit")
    @ApiOperation(value = "审核调拨单", notes = "审核调拨单")
    RestResponse<List<StorageCheckRespDto>> auditTransferOrder(@RequestBody TransferOrderAuditReqDto reqDto);
    /**
     * 审核调拨单
     *
     * @return
     */
    @PutMapping("/tcbjPhysicLogicWarehouseOut")
    @ApiOperation(value = "修改物理库存", notes = "修改物理库存")
    RestResponse<Void> tcbjPhysicLogicWarehouseOut(@RequestBody TcbjStockChangeDto reqDto);
}
