/*
 * @(#)InventoryException.java 1.0 2018-08-30
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseCargoCreateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;

/**
 * 仓库货品查询接口
 *
 * @author 浮云
 */
@Api(tags = {"库存中心：仓库货品查询服务"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/warehouse/cargo")
public interface IWarehouseCargoApi {


    @PostMapping("/batchAdd")
    @ApiOperation(value = "批量新增仓库货品", notes = "批量新增仓库货品")
    RestResponse<Void> batchAdd(@RequestBody WarehouseCargoCreateReqDto warehouseCargoCreateReqDto);

    /**
     * 更新库存共享状态
     *
     * @param id                   仓库货品id
     * @param inventoryShareStatus 库存共享状态： 0 不开启 ，1 开启
     * @return
     */
    @ApiOperation(value = "更新库存共享状态", notes = "更新库存共享状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", paramType = "query", dataType = "Long", value = "仓库货品关联id"),
            @ApiImplicitParam(name = "inventoryShareStatus", paramType = "query", dataType = "Integer", value = "库存共享状态： 0 不开启 ，1 开启")
    })
    @GetMapping("/updateInventoryShareStatus")
    RestResponse<Void> updateInventoryShareStatus(@RequestParam("id") Long id,
                                                  @RequestParam("inventoryShareStatus") Integer inventoryShareStatus);


    /**
     * 货品库存操作
     *
     * @param cargoStorageInfoCreateReqDto 货品扣减库存请求DTO
     * @return 操作结果
     */
    @PostMapping("/sub")
    @ApiOperation(value = "货品库存扣减", notes = "1,预占，2扣减")
    RestResponse<Void> subCargoStorage(@Valid @RequestBody CargoStorageInfoCreateReqDto cargoStorageInfoCreateReqDto);


}