package com.dtyunxi.yundt.cube.center.inventory.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * 仓库路由得分服务接口
 *
 * @author: fuyun
 * @Date: 2020/7/30 16:58
 */
@Api(tags = {"库存中心：仓库路由得分服务接口"})
@FeignClient(
        name = "${dtyunxi.yundt.cube_base-center-inventory_api.name:base-center-inventory}",
        url = "${dtyunxi.yundt.cube_base-center-inventory_api:}",
        path = "/v2/warehouse/route/score"
)
public interface IWarehouseRouteScoreApi {

    /**
     * 计算仓库各渠道路由得分
     */
    @GetMapping(value = "initScore", produces = "application/json")
    @ApiOperation(value = "计算仓库各渠道路由得分", notes = "计算仓库各渠道路由得分")
    @Deprecated
    void initScore();
}
