/**
 * @(#) StorageOrderStatusEnum.java 1.0 2018-10-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 单据状态枚举
 * 1：待提交、2：待审核:3：待执行、4：审核不通过，5：已完结、6：取消、7：执行失败
 *
 * @author 魄罗
 * @since 2.0.0
 */
public enum BillStatusEnum {
    WAIT_COMMIT(1, "待提交"),
    WAIT_AUDIT(2, "待审核"),
    TOBE_DELIVERED(3, "待执行"),
    AUDIT_NO_PASS(4, "审核不通过"),
    SUCCESS(5, "已完结"),
    FAIL(6, "取消"),
    FAILED_ISSUE(7, "执行失败");


    private Integer status;
    private String desc;

    BillStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
