package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 库存流水类型
 *
 * @Enum ChangeLogTypeEnum
 * @Author huangxueji
 * @Date 2020/7/28 11:13
 */
public enum ChangeLogTypeEnum {

    SALES_ORDER(1, "销售订单"),
    AFTER_SALES_ORDER(2, "售后订单"),
    DISTRIBUTION_ORDER(3, "配货单"),
    REPLENISHMENT_ORDER(4, "补货单"),
    DISPATCH_ORDER(5, "调货单"),
    RETURN_ORDER(6, "返货单"),
    STORAGE_ADJUST_ORDER(7, "库存调整");


    private Integer status;
    private String statusName;

    ChangeLogTypeEnum() {
    }

    ChangeLogTypeEnum(Integer status, String statusName) {
        this.status = status;
        this.statusName = statusName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStatusName() {
        return statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }
}
