/**
 * @(#) DeliveryStatusEnums.java 1.0 2018-08-30
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 描述
 *
 * @author 魄罗
 * @since 1.0.0
 */
public enum DeliveryOrderStatusEnum {
    INIT("INIT", "已创建"),
    PICKING("PICKING", "拣货"),
    SEND_OUT_PART("SEND_OUT_PART", "部分出库"),
    SEND_OUT("SEND_OUT","出库完成"),
    CANCEL("CANCEL","已经取消"),
    FINISH("FINISH", "已完成")
    ;

    private String status;
    private String statusName;

    DeliveryOrderStatusEnum(String status, String statusName){
        this.status = status;
        this.statusName = statusName;
    }

    public static String getStatusName(String status){
        if (status == null){
            return null;
        }
        for (DeliveryOrderStatusEnum deliveryOrderStatusEnum : DeliveryOrderStatusEnum.values()){
            if (status.equals(deliveryOrderStatusEnum.getStatus())){
                return deliveryOrderStatusEnum.getStatusName();
            }
        }
        return null;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusName() {
        return statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }
}
