package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 库存共享状态枚举
 *
 * @author: fuyun
 * @Date: 2020/7/21 18:10
 */
public enum InventoryShareStatusEnum {
    /**
     * 库存共享状态： 0 不开启 ，1 开启
     */
    OPEN(1, "开启"),
    CLOSE(0, "关闭");
    /**
     * 状态
     */
    private Integer status;

    /**
     * 描述
     */
    private String desc;

    InventoryShareStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
