/*
 * @(#)MessageTag.java 1.0 2018-11-05
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * @author 简树
 * @since 2.0.0
 */
public interface MessageTag {
    /**
     * 订单发货(跟交易中心重复，会抢消息)
     */
    String ORDER_DELIVERY = "order_delivery2";
    /**
     * 订单发货-消息发送
     */
    String PRODUCER_ORDER_DELIVERY_CONFIRM_DELIVERY = "order_delivery2_confirm_delivery";
    /**
     * 订单发货-消息接收
     */
    String CUSTOMER_ORDER_DELIVERY_WAIT_DELIVERY = "order_delivery2_wait_delivery";
    /**
     * 出库消息
     */
    String DELIVERY_STORAGE_OUT = "delivery_storage_out3";
    /**
     * 货品库存
     */
    String cargoStorageTagName = "cargo_storage6";
    /**
     * 货品库存
     */
    String newCargoStorageTagName = "cargo_storage7";
    /**
     * 查询物流信息
     */
    String queryTraceTagName = "query_trace";

    /**
     * WMS库存变更同步中台
     */
    String WMS_CHANGE_INVENTORY = "wmsChangeInventory";

    /**
     * 库存调整同步
     */
    String BIZ_TO_EXTERNAL_SYSTEM = "BIZ_TO_EXTERNAL_SYSTEM";
    /**
     * 库存调整内部消息
     */
    String INVENTORY_CHANGE_IN_MESSAGE = "inventoryChangeInMessage";
    /**
     * 库存调整内部消息
     */
    String INVENTORY_CHANGE_IN_MESSAGE_TEST = "inventoryChangeInMessagetest";
    /**
     * 安全库存比例变动内部消息
     */
    String INVENTORY_SAFETY_STOCK_MESSAGE = "inventorySafetyStockMessage";

    /**
     * 同步发货单到库存中心TAG
     */
    String INVENTORY_DELIVERY_TAG = "INVENTORY_DELIVERY_TAG";

    /**
     * 发货单路由结果tag
     */
    String INVENTORY_ROUTE_RESULT_TAG = "INVENTORY_ROUTE_RESULT_TAG";

    /**
     * 发货单路由拆单结果tag
     */
    String INVENTORY_ROUTE_SPLIT_RESULT_TAG = "INVENTORY_ROUTE_SPLIT_RESULT_TAG";

    /**
     * 更新发货单状态tag
     */
    String INVENTORY_DELIVERY_CHANGE_TAG = "INVENTORY_DELIVERY_CHANGE_TAG";

    /**
     * 发货单路由指令tag
     */
    String INVENTORY_ROUTE_COMMAND_TAG = "INVENTORY_ROUTE_COMMAND_TAG";

    /**

     * 入库消息
     */
    String RETURN_STORAGE_IN = "return_storage_in";
    /**
     * 交易中心拆分发货单同步发货单到库存中心tag
     */
    String TRADE_DELIVERY_SPLIT_TAG = "TRADE_DELIVERY_SPLIT_TAG";

    /**
     * 交易中心合并发货单同步发货单到库存中心tag
     */
    String TRADE_DELIVERY_MERGE_TAG = "TRADE_DELIVERY_MERGE_TAG";
//
//    /**
//     * 库存调整内部消息
//     */
//    String INVENTORY_CHANGE_IN_MESSAGE_TEST = "inventoryChangeInMessage";
//
//    /**
//     * 安全库存比例变动内部消息
//     */
//    String INVENTORY_SAFETY_STOCK_MESSAGE = "inventorySafetyStockMessage";

}
