/**
 * @(#) StorageOrderStatusEnum.java 1.0 2018-10-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 出库单状态枚举
 *
 * @author 魄罗
 * @since 2.0.0
 */
public enum OutStorageOrderStatusEnum {
    WAIT_COMMIT(1, "待提交"),
    WAIT_AUDIT(2, "待审核"),
    AUDIT_NO_PASS(3, "审核不通过"),
    WAIT_OUT(4, "待出库"),
    WAIT_DELIVER(5, "待发货"),
    FINISH(6, "已出库"),
    CANCEL(7, "已取消");


    private Integer status;
    private String desc;

    OutStorageOrderStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static String nameOf(Integer status){
        if (status == null){
            return null;
        }
        for (OutStorageOrderStatusEnum value : values()) {
            if (value.status.equals(status)) {
                return value.getDesc();
            }
        }
        return null;
    }


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
