package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 仓库关联类型
 *
 * @Enum RefWarehouseType
 * @Author chunjiu
 * @Date 2020/9/14 19:05
 */
public enum RefWarehouseTypeEnum {

    REF_WAREHOUSE(1, "仓库关联"),
    REF_CARGO(2, "货品关联");

    private Integer code;
    private String name;

    RefWarehouseTypeEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    public static String getStatusName(String status){
        if (status == null){
            return null;
        }
        for (DeliveryOrderStatusEnum deliveryOrderStatusEnum : DeliveryOrderStatusEnum.values()){
            if (status.equals(deliveryOrderStatusEnum.getStatus())){
                return deliveryOrderStatusEnum.getStatusName();
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
