package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 定时任务枚举
 *
 * @author: fuyun
 * @Date: 2020/11/17 15:42
 */
public enum SchedulerEnum {
    /**
     * 定时任务枚举
     */
    DELIVERY_TIME_LIMIT("deliveryTimeLimitEvent", "发货阈值计算定时任务"),
    DELIVER_THRESHOLD("deliverThresholdEvent", "发货阈值计算定时任务"),
    CARGO_STORAGE_SHARE("cargoStorageShareEvent", "货品库存共享定时任务"),
    ;

    SchedulerEnum(String bizCode, String bizName) {
        this.bizCode = bizCode;
        this.bizName = bizName;
    }

    /**
     * 任务code
     */
    private String bizCode;

    /**
     * 任务名称
     */
    private String bizName;

    public String getBizCode() {
        return bizCode;
    }

    public void setBizCode(String bizCode) {
        this.bizCode = bizCode;
    }

    public String getBizName() {
        return bizName;
    }

    public void setBizName(String bizName) {
        this.bizName = bizName;
    }
}
