package com.dtyunxi.yundt.cube.center.inventory.api.constants;

/**
 * 任务状态
 *
 * @ClassName ShareStorageStatus
 * @Author chunjiu
 * @Date 2020/9/12 17:27enum
 */
public enum ShareStorageStatusEnum {
    EXECUTE_WAIT(0, "待执行"),
    EXECUTE_SUCCESS(1, "执行成功"),
    EXECUTE_FALSE(2, "执行失败");

    private Integer code;
    private String name;

    ShareStorageStatusEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    public static String getStatusName(String status){
        if (status == null){
            return null;
        }
        for (DeliveryOrderStatusEnum deliveryOrderStatusEnum : DeliveryOrderStatusEnum.values()){
            if (status.equals(deliveryOrderStatusEnum.getStatus())){
                return deliveryOrderStatusEnum.getStatusName();
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
