package com.dtyunxi.yundt.cube.center.inventory.api.constants;

import com.dtyunxi.exceptions.BizException;

/**
 *
 * 库存类型
 * @author ganguo.ggw@dtyunxi.com
 * @version 1.0.0
 * @company 云徙科技[www.dtyunxi.com]
 * @createTime 2021年07月20日 11:22:00
 */
public enum StockTypeEnum {

    PREEMPT("PREEMPT", "预占库存"),
    AVAILABLE("AVAILABLE","可用"),
    INTRANSIT("INTRANSIT", "'在途'"),
    FUTURES_INVENTORY("FUTURES_INVENTORY", "期货库存"),
    BALANCE("BALANCE", "在库库存");

    /**
     * 值
     */
    private final String value;

    /**
     * 值描述
     */
    private final String desc;

    StockTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static StockTypeEnum getInstance(String value){
        for(StockTypeEnum e : StockTypeEnum.values()) {
            if(e.getValue().equals(value)) {
                return e;
            }
        }
        throw new BizException("stock type not found value:"+value);
    }

    /**
     *
     *  通过值获取值描述
     */
    public static String getDescByValue(String value) {
        for(StockTypeEnum e : StockTypeEnum.values()) {
            if(e.getValue().equals(value)) {
                return e.getDesc();
            }
        }
        return null;
    }
}
