/**
 * @(#) CargoStorageChangeStatusEnum.java 1.0 2018-09-04
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.constants;

import org.apache.commons.lang3.StringUtils;

/**
 * 货品库存变更状态类型
 *
 * @author 魄罗
 * @since 2.0.0
 */
public enum StorageChangeStatusEnum {
    INIT("INIT", "初始化状态"),
    APPENDED("APPENDED", "已预占"),
    CONFIRM("CONFIRM", "已确认"),
    ROLLBACK("ROLLBACK", "已回滚"),
    STORAGE_IN("STORAGE_IN", "入库成功"),
    STORAGE_OUT("STORAGE_OUT", "出库成功"),
    FAIL("FAIL", "操作失败")
    ;

    private String status;

    private String statusName;

    StorageChangeStatusEnum(String status, String statusName){
        this.status = status;
        this.statusName = statusName;
    }

    public static String getStatusName(String status){
        if (StringUtils.isBlank(status)){
            return null;
        }
        for (StorageChangeStatusEnum storageChangeStatusEnum : StorageChangeStatusEnum.values()){
            if (status.equals(storageChangeStatusEnum.getStatus())){
                return storageChangeStatusEnum.getStatusName();
            }
        }
        return null;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusName() {
        return statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }
}
